/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.lazy;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.internal.lazy.Lazy;

class AtomicLazy<T>
implements Lazy<T> {
    private static final Object UNINITIALIZED = new Object();
    private final AtomicReference<Object> value = new AtomicReference<Object>(UNINITIALIZED);
    @Nullable
    private volatile Supplier<T> supplier;

    public AtomicLazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public T get() {
        Supplier<T> s = this.supplier;
        if (s != null) {
            T t = s.get();
            if (this.value.compareAndSet(UNINITIALIZED, t)) {
                this.supplier = null;
                return t;
            }
            this.supplier = null;
        }
        return (T)this.value.get();
    }
}

