/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.text.whitespace;

import org.pentaho.reporting.libraries.fonts.text.whitespace.WhiteSpaceFilter;

public class DiscardWhiteSpaceFilter
implements WhiteSpaceFilter {
    public static final char ZERO_WIDTH = '\u200b';
    private boolean lastWasWhiteSpace;

    @Override
    public void reset() {
        this.lastWasWhiteSpace = false;
    }

    @Override
    public int filter(int codepoint) {
        if (Character.isWhitespace((char)codepoint)) {
            if (!this.lastWasWhiteSpace) {
                this.lastWasWhiteSpace = true;
                return 8203;
            }
            return -1;
        }
        if (codepoint == Integer.MIN_VALUE) {
            this.lastWasWhiteSpace = true;
            return -1;
        }
        if (codepoint == Integer.MAX_VALUE) {
            return -1;
        }
        this.lastWasWhiteSpace = false;
        return codepoint;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

