/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.internaldafny.types;

import BoundedInts_Compile.uint8;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;

public class ValidatePublicKeyInput {
    public ECDHCurveSpec _eccCurve;
    public DafnySequence<? extends Byte> _publicKey;
    private static final TypeDescriptor<ValidatePublicKeyInput> _TYPE = TypeDescriptor.referenceWithInitializer(ValidatePublicKeyInput.class, () -> ValidatePublicKeyInput.Default());
    private static final ValidatePublicKeyInput theDefault = ValidatePublicKeyInput.create(ECDHCurveSpec.Default(), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));

    public ValidatePublicKeyInput(ECDHCurveSpec eccCurve, DafnySequence<? extends Byte> publicKey) {
        this._eccCurve = eccCurve;
        this._publicKey = publicKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ValidatePublicKeyInput o = (ValidatePublicKeyInput)other;
        return Objects.equals(this._eccCurve, o._eccCurve) && Objects.equals(this._publicKey, o._publicKey);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._eccCurve);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._publicKey);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyPrimitivesTypes.ValidatePublicKeyInput.ValidatePublicKeyInput");
        s.append("(");
        s.append(Helpers.toString((Object)this._eccCurve));
        s.append(", ");
        s.append(Helpers.toString(this._publicKey));
        s.append(")");
        return s.toString();
    }

    public static TypeDescriptor<ValidatePublicKeyInput> _typeDescriptor() {
        return _TYPE;
    }

    public static ValidatePublicKeyInput Default() {
        return theDefault;
    }

    public static ValidatePublicKeyInput create(ECDHCurveSpec eccCurve, DafnySequence<? extends Byte> publicKey) {
        return new ValidatePublicKeyInput(eccCurve, publicKey);
    }

    public static ValidatePublicKeyInput create_ValidatePublicKeyInput(ECDHCurveSpec eccCurve, DafnySequence<? extends Byte> publicKey) {
        return ValidatePublicKeyInput.create(eccCurve, publicKey);
    }

    public boolean is_ValidatePublicKeyInput() {
        return true;
    }

    public ECDHCurveSpec dtor_eccCurve() {
        return this._eccCurve;
    }

    public DafnySequence<? extends Byte> dtor_publicKey() {
        return this._publicKey;
    }
}

