/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class TimestampDiffFunction
extends ImplementorUDF {
    public TimestampDiffFunction() {
        super(new DiffImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return ReturnTypes.BIGINT_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.INTERVAL_DATETIME_DATETIME;
    }

    public static class DiffImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            int startIndex = 1;
            int endIndex = 2;
            ExprType startType = OpenSearchTypeFactory.convertRelDataTypeToExprType(((RexNode)call.getOperands().get(startIndex)).getType());
            ExprType endType = OpenSearchTypeFactory.convertRelDataTypeToExprType(((RexNode)call.getOperands().get(endIndex)).getType());
            MethodCallExpression functionProperties = Expressions.call(UserDefinedFunctionUtils.class, (String)"restoreFunctionProperties", (Expression[])new Expression[]{translator.getRoot()});
            NewExpression unit = Expressions.new_(ExprStringValue.class, (Expression[])new Expression[]{translatedOperands.getFirst()});
            MethodCallExpression start = Expressions.call(ExprValueUtils.class, (String)"fromObjectValue", (Expression[])new Expression[]{translatedOperands.get(startIndex), Expressions.constant((Object)startType)});
            MethodCallExpression end = Expressions.call(ExprValueUtils.class, (String)"fromObjectValue", (Expression[])new Expression[]{translatedOperands.get(endIndex), Expressions.constant((Object)endType)});
            if (ExprCoreType.TIME.equals(startType) || ExprCoreType.TIME.equals(endType)) {
                return Expressions.call(DiffImplementor.class, (String)"diffForTime", (Expression[])new Expression[]{functionProperties, unit, start, end});
            }
            return Expressions.call(DiffImplementor.class, (String)"diff", (Expression[])new Expression[]{unit, start, end});
        }

        public static long diff(ExprStringValue unit, ExprValue start, ExprValue end) {
            ExprValue diffResult = DateTimeFunctions.exprTimestampDiff(unit, start, end);
            return diffResult.longValue();
        }

        public static long diffForTime(FunctionProperties functionProperties, ExprStringValue unit, ExprValue start, ExprValue end) {
            return DateTimeFunctions.exprTimestampDiffForTimeType(functionProperties, unit, start, end).longValue();
        }
    }
}

