/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.script.ScriptType;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.utils.Util;

public class ScriptFilter {
    private String script;
    private Map<String, Object> args;
    private ScriptType scriptType;

    public ScriptFilter() {
        this.args = null;
        this.scriptType = ScriptType.INLINE;
    }

    public ScriptFilter(String script, Map<String, Object> args, ScriptType scriptType) {
        this.script = script;
        this.args = args;
        this.scriptType = scriptType;
    }

    public boolean tryParseFromMethodExpr(SQLMethodInvokeExpr expr) throws SqlParseException {
        if (!expr.getMethodName().toLowerCase().equals("script")) {
            return false;
        }
        List methodParameters = expr.getParameters();
        if (methodParameters.size() == 0) {
            return false;
        }
        this.script = Util.extendedToString((SQLExpr)methodParameters.get(0));
        if (methodParameters.size() == 1) {
            return true;
        }
        this.args = new HashMap<String, Object>();
        for (int i = 1; i < methodParameters.size(); ++i) {
            SQLExpr innerExpr = (SQLExpr)methodParameters.get(i);
            if (!(innerExpr instanceof SQLBinaryOpExpr)) {
                return false;
            }
            SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)innerExpr;
            if (!binaryOpExpr.getOperator().getName().equals("=")) {
                return false;
            }
            SQLExpr right = binaryOpExpr.getRight();
            Object value = Util.expr2Object(right);
            String key = Util.extendedToString(binaryOpExpr.getLeft());
            if (key.equals("script_type")) {
                this.parseAndUpdateScriptType(value.toString());
                continue;
            }
            this.args.put(key, value);
        }
        return true;
    }

    private void parseAndUpdateScriptType(String scriptType) {
        String scriptTypeUpper;
        switch (scriptTypeUpper = scriptType.toUpperCase()) {
            case "INLINE": {
                this.scriptType = ScriptType.INLINE;
                break;
            }
            case "INDEXED": 
            case "STORED": {
                this.scriptType = ScriptType.STORED;
            }
        }
    }

    public boolean containsParameters() {
        return this.args != null && this.args.size() > 0;
    }

    public String getScript() {
        return this.script;
    }

    public ScriptType getScriptType() {
        return this.scriptType;
    }

    public Map<String, Object> getArgs() {
        return this.args;
    }

    public void setArgs(Map<String, Object> args) {
        this.args = args;
    }
}

