/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.opensearch.script.AggregationScript;
import org.opensearch.script.FilterScript;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptEngine;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.opensearch.storage.script.aggregation.ExpressionAggregationScriptFactory;
import org.opensearch.sql.opensearch.storage.script.filter.ExpressionFilterScriptFactory;
import org.opensearch.sql.opensearch.storage.serde.ExpressionSerializer;
import shaded.com.google.common.collect.ImmutableMap;

public class ExpressionScriptEngine
implements ScriptEngine {
    public static final String EXPRESSION_LANG_NAME = "opensearch_query_expression";
    private static final Map<ScriptContext<?>, Function<Expression, Object>> CONTEXTS = new ImmutableMap.Builder().put((Object)FilterScript.CONTEXT, ExpressionFilterScriptFactory::new).put((Object)AggregationScript.CONTEXT, ExpressionAggregationScriptFactory::new).build();
    private final ExpressionSerializer serializer;

    public String getType() {
        return EXPRESSION_LANG_NAME;
    }

    public <T> T compile(String scriptName, String scriptCode, ScriptContext<T> context, Map<String, String> params) {
        Expression expression = this.serializer.deserialize(scriptCode);
        if (CONTEXTS.containsKey(context)) {
            return context.factoryClazz.cast(CONTEXTS.get(context).apply(expression));
        }
        throw new IllegalStateException(String.format("Script context is currently not supported: all supported contexts [%s], given context [%s] ", CONTEXTS, context));
    }

    public Set<ScriptContext<?>> getSupportedContexts() {
        return CONTEXTS.keySet();
    }

    @Generated
    public ExpressionScriptEngine(ExpressionSerializer serializer) {
        this.serializer = serializer;
    }
}

