/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client;

import java.io.IOException;
import java.util.Arrays;
import org.opensearch.OpenSearchException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.common.Nullable;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.remote.metadata.client.DataObjectResponse;
import org.opensearch.remote.metadata.client.DeleteDataObjectResponse;
import org.opensearch.remote.metadata.client.PutDataObjectResponse;
import org.opensearch.remote.metadata.client.UpdateDataObjectResponse;
import org.opensearch.remote.metadata.common.SdkClientUtils;

public class BulkDataObjectResponse {
    private final DataObjectResponse[] responses;
    private final long tookInMillis;
    private final long ingestTookInMillis;
    private final boolean failures;
    private final XContentParser parser;
    private final BulkResponse bulkResponse;

    public BulkDataObjectResponse(BulkResponse bulkResponse) {
        this(BulkDataObjectResponse.generateDataObjectResponseArray(bulkResponse), bulkResponse.getTook().millis(), -1L, bulkResponse.hasFailures(), null, bulkResponse);
    }

    private static DataObjectResponse[] generateDataObjectResponseArray(BulkResponse bulkResponse) {
        return (DataObjectResponse[])Arrays.stream(bulkResponse.getItems()).map(itemResponse -> switch (itemResponse.getOpType()) {
            case DocWriteRequest.OpType.INDEX, DocWriteRequest.OpType.CREATE -> new PutDataObjectResponse((BulkItemResponse)itemResponse);
            case DocWriteRequest.OpType.UPDATE -> new UpdateDataObjectResponse((BulkItemResponse)itemResponse);
            case DocWriteRequest.OpType.DELETE -> new DeleteDataObjectResponse((BulkItemResponse)itemResponse);
            default -> throw new OpenSearchException("Invalid operation type for bulk response", new Object[]{RestStatus.INTERNAL_SERVER_ERROR});
        }).toArray(DataObjectResponse[]::new);
    }

    public BulkDataObjectResponse(DataObjectResponse[] responses, long tookInMillis, boolean failures, XContentParser parser) {
        this(responses, tookInMillis, -1L, failures, parser, null);
    }

    public BulkDataObjectResponse(DataObjectResponse[] responses, long tookInMillis, long ingestTookInMillis, boolean failures, XContentParser parser) {
        this(responses, tookInMillis, ingestTookInMillis, failures, parser, null);
    }

    private BulkDataObjectResponse(DataObjectResponse[] responses, long tookInMillis, long ingestTookInMillis, boolean failures, XContentParser parser, BulkResponse bulkResponse) {
        this.responses = responses;
        this.tookInMillis = tookInMillis;
        this.ingestTookInMillis = ingestTookInMillis;
        this.failures = failures;
        this.parser = parser;
        this.bulkResponse = bulkResponse;
    }

    public DataObjectResponse[] getResponses() {
        return this.responses;
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public long getIngestTookInMillis() {
        return this.ingestTookInMillis;
    }

    public boolean hasFailures() {
        return this.failures;
    }

    @Nullable
    public BulkResponse bulkResponse() {
        if (this.bulkResponse == null) {
            try {
                return BulkResponse.fromXContent((XContentParser)this.parser);
            }
            catch (IOException | NullPointerException e) {
                return null;
            }
        }
        return this.bulkResponse;
    }

    public XContentParser parser() {
        if (this.parser == null) {
            try {
                return SdkClientUtils.createParser((ToXContent)this.bulkResponse);
            }
            catch (IOException | NullPointerException e) {
                return null;
            }
        }
        return this.parser;
    }
}

