/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.inject.Singleton;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.protobufs.QueryContainer;
import org.opensearch.transport.grpc.proto.request.search.query.MatchAllQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.MatchNoneQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.QueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.TermQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.TermsQueryBuilderProtoConverter;

@Singleton
public class QueryBuilderProtoConverterRegistry {
    private static final Logger logger = LogManager.getLogger(QueryBuilderProtoConverterRegistry.class);
    private final Map<QueryContainer.QueryContainerCase, QueryBuilderProtoConverter> converterMap = new HashMap<QueryContainer.QueryContainerCase, QueryBuilderProtoConverter>();

    @Inject
    public QueryBuilderProtoConverterRegistry() {
        this.registerBuiltInConverters();
        this.loadExternalConverters();
    }

    protected void registerBuiltInConverters() {
        this.registerConverter(new MatchAllQueryBuilderProtoConverter());
        this.registerConverter(new MatchNoneQueryBuilderProtoConverter());
        this.registerConverter(new TermQueryBuilderProtoConverter());
        this.registerConverter(new TermsQueryBuilderProtoConverter());
        logger.info("Registered {} built-in query converters", (Object)this.converterMap.size());
    }

    protected void loadExternalConverters() {
        ServiceLoader<QueryBuilderProtoConverter> serviceLoader = ServiceLoader.load(QueryBuilderProtoConverter.class);
        Iterator<QueryBuilderProtoConverter> iterator = serviceLoader.iterator();
        int count = 0;
        int failedCount = 0;
        while (iterator.hasNext()) {
            try {
                QueryBuilderProtoConverter converter = iterator.next();
                this.registerConverter(converter);
                ++count;
                logger.info("Loaded external query converter for {}: {}", (Object)converter.getHandledQueryCase(), (Object)converter.getClass().getName());
            }
            catch (Exception e) {
                ++failedCount;
                logger.error("Failed to load external query converter", (Throwable)e);
            }
        }
        logger.info("Loaded {} external query converters ({} failed)", (Object)count, (Object)failedCount);
    }

    public QueryBuilder fromProto(QueryContainer queryContainer) {
        if (queryContainer == null) {
            throw new IllegalArgumentException("Query container cannot be null");
        }
        QueryContainer.QueryContainerCase queryCase = queryContainer.getQueryContainerCase();
        QueryBuilderProtoConverter converter = this.converterMap.get(queryCase);
        if (converter != null) {
            logger.debug("Using converter for {}: {}", (Object)queryCase, (Object)converter.getClass().getName());
            return converter.fromProto(queryContainer);
        }
        throw new IllegalArgumentException("Unsupported query type in container: " + String.valueOf(queryContainer) + " (case: " + String.valueOf(queryCase) + ")");
    }

    public void registerConverter(QueryBuilderProtoConverter converter) {
        if (converter == null) {
            throw new IllegalArgumentException("Converter cannot be null");
        }
        QueryContainer.QueryContainerCase queryCase = converter.getHandledQueryCase();
        if (queryCase == null) {
            throw new IllegalArgumentException("Handled query case cannot be null for converter: " + converter.getClass().getName());
        }
        if (queryCase == QueryContainer.QueryContainerCase.QUERYCONTAINER_NOT_SET) {
            throw new IllegalArgumentException("Cannot register converter for QUERYCONTAINER_NOT_SET case: " + converter.getClass().getName());
        }
        QueryBuilderProtoConverter existingConverter = this.converterMap.put(queryCase, converter);
        if (existingConverter != null) {
            logger.warn("Replacing existing converter for query type {}: {} -> {}", (Object)queryCase, (Object)existingConverter.getClass().getName(), (Object)converter.getClass().getName());
        }
        logger.debug("Registered query converter for {}: {}", (Object)queryCase, (Object)converter.getClass().getName());
    }
}

