/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.index.query.xypoint;

import java.util.Locale;
import org.apache.lucene.search.Query;
import org.opensearch.common.geo.ShapeRelation;
import org.opensearch.geometry.Geometry;
import org.opensearch.geometry.GeometryVisitor;
import org.opensearch.geospatial.index.mapper.xypoint.XYPointFieldMapper;
import org.opensearch.geospatial.index.query.xypoint.XYPointQueryVisitor;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;

public class XYPointQueryProcessor {
    public Query shapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        this.validateIsXYPointFieldType(fieldName, context);
        if (relation != ShapeRelation.INTERSECTS) {
            throw new QueryShardException(context, String.format(Locale.ROOT, "[%s] query relation not supported for Field [%s]", relation, fieldName), new Object[0]);
        }
        return this.getVectorQueryFromShape(shape, fieldName, context);
    }

    private void validateIsXYPointFieldType(String fieldName, QueryShardContext context) {
        MappedFieldType fieldType = context.fieldMapper(fieldName);
        if (fieldType instanceof XYPointFieldMapper.XYPointFieldType) {
            return;
        }
        throw new QueryShardException(context, String.format(Locale.ROOT, "Expected [%s] field type for Field [%s] but found [%s]", "xy_point", fieldName, fieldType.typeName()), new Object[0]);
    }

    protected Query getVectorQueryFromShape(Geometry queryShape, String fieldName, QueryShardContext context) {
        XYPointQueryVisitor xyPointQueryVisitor = new XYPointQueryVisitor(fieldName, context.fieldMapper(fieldName), context);
        return (Query)queryShape.visit((GeometryVisitor)xyPointQueryVisitor);
    }
}

