/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.memorycontainer.memory;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.memorycontainer.MLMemory;
import org.opensearch.ml.common.memorycontainer.MLMemoryContainer;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLGetMemoryRequest;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLGetMemoryResponse;
import org.opensearch.ml.helper.MemoryContainerHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportGetMemoryAction
extends HandledTransportAction<ActionRequest, MLGetMemoryResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportGetMemoryAction.class);
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final MemoryContainerHelper memoryContainerHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportGetMemoryAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry, MemoryContainerHelper memoryContainerHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/memory_containers/memory/get", transportService, actionFilters, MLGetMemoryRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.memoryContainerHelper = memoryContainerHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLGetMemoryResponse> actionListener) {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            actionListener.onFailure((Exception)new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        MLGetMemoryRequest getRequest = MLGetMemoryRequest.fromActionRequest((ActionRequest)request);
        String memoryContainerId = getRequest.getMemoryContainerId();
        String memoryId = getRequest.getMemoryId();
        this.memoryContainerHelper.getMemoryContainer(memoryContainerId, (ActionListener<MLMemoryContainer>)ActionListener.wrap(container -> {
            User user = RestActionUtils.getUserContext(this.client);
            if (!this.memoryContainerHelper.checkMemoryContainerAccess(user, (MLMemoryContainer)container)) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have permissions to get memories in this container", RestStatus.FORBIDDEN, new Object[0]));
                return;
            }
            if (!this.memoryContainerHelper.validateMemoryIndexExists((MLMemoryContainer)container, "GET", actionListener)) {
                return;
            }
            String memoryIndexName = this.memoryContainerHelper.getMemoryIndexName((MLMemoryContainer)container);
            GetRequest getMemoryRequest = new GetRequest(memoryIndexName, memoryId);
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.client.get(getMemoryRequest, ActionListener.wrap(getResponse -> this.processResponse((GetResponse)getResponse, memoryId, memoryContainerId, actionListener), exception -> {
                    log.error("Failed to get memory {} from container {}", (Object)memoryId, (Object)memoryContainerId, exception);
                    actionListener.onFailure(exception);
                }));
            }
            catch (Exception e) {
                log.error("Failed to get memory {} from container {}", (Object)memoryId, (Object)memoryContainerId, (Object)e);
                actionListener.onFailure(e);
            }
        }, arg_0 -> actionListener.onFailure(arg_0)));
    }

    private void processResponse(GetResponse getResponse, String memoryId, String memoryContainerId, ActionListener<MLGetMemoryResponse> actionListener) {
        block11: {
            try {
                if (getResponse.isExists()) {
                    try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getResponse.getSourceAsString());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        MLMemory mlMemory = MLMemory.parse((XContentParser)parser);
                        MLGetMemoryResponse response = MLGetMemoryResponse.builder().mlMemory(mlMemory).build();
                        actionListener.onResponse((Object)response);
                        break block11;
                    }
                    catch (Exception e) {
                        log.error("Failed to parse memory response for id: {}", (Object)memoryId, (Object)e);
                        actionListener.onFailure(e);
                    }
                    break block11;
                }
                actionListener.onFailure((Exception)new OpenSearchStatusException("Memory not found with id: " + memoryId, RestStatus.NOT_FOUND, new Object[0]));
            }
            catch (Exception e) {
                log.error("Failed to process memory response for id: {} from container {}", (Object)memoryId, (Object)memoryContainerId, (Object)e);
                actionListener.onFailure(e);
            }
        }
    }
}

