/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class AckAlertsRequest
extends ActionRequest {
    private final String detectorId;
    private final List<String> alertIds;

    public AckAlertsRequest(String detectorId, List<String> alertIds) {
        this.detectorId = detectorId;
        this.alertIds = alertIds;
    }

    public AckAlertsRequest(StreamInput in) throws IOException {
        this.detectorId = in.readString();
        this.alertIds = Collections.unmodifiableList(in.readStringList());
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.detectorId == null) {
            validationException = ValidateActions.addValidationError((String)"detector id is mandatory", validationException);
        } else if (this.alertIds == null || this.alertIds.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"alert ids list cannot be empty", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.detectorId);
        out.writeStringCollection(this.alertIds);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("detector_id", this.detectorId).field("alert_ids", this.alertIds).endObject();
    }

    public static AckAlertsRequest readFrom(StreamInput sin) throws IOException {
        return new AckAlertsRequest(sin);
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public List<String> getAlertIds() {
        return this.alertIds;
    }
}

