/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opensearch.searchrelevance.metrics.calculator.Evaluation;

public class EvaluationMetrics {
    private static void addMetric(List<Map<String, Object>> metrics, String metricName, double value) {
        HashMap<String, Object> metric = new HashMap<String, Object>();
        metric.put("metric", metricName);
        metric.put("value", value);
        metrics.add(metric);
    }

    public static List<Map<String, Object>> calculateEvaluationMetrics(List<String> docIds, Map<String, String> judgments, int k) {
        ArrayList<Map<String, Object>> metrics = new ArrayList<Map<String, Object>>();
        List<String> docsWithScores = docIds.stream().filter(judgments::containsKey).toList();
        int totalCount = docIds.size();
        int totalDocsWithScores = docsWithScores.size();
        double coverage = totalCount > 0 ? (double)Math.round((double)totalDocsWithScores / (double)totalCount * 100.0) / 100.0 : 0.0;
        EvaluationMetrics.addMetric(metrics, String.format(Locale.ROOT, "Coverage@%d", k), coverage);
        EvaluationMetrics.addMetric(metrics, "Precision@" + k, Evaluation.calculatePrecisionAtK(docIds, judgments, k));
        EvaluationMetrics.addMetric(metrics, "MAP@" + k, Evaluation.calculateMAPAtK(docIds, judgments, k));
        EvaluationMetrics.addMetric(metrics, "NDCG@" + k, Evaluation.calculateNDCGAtK(docIds, judgments, k));
        return metrics;
    }
}

