/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.ml;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.searchrelevance.ml.ChunkResult;

public class ChunkProcessingContext {
    private static final Logger LOGGER = LogManager.getLogger(ChunkProcessingContext.class);
    private final ConcurrentMap<Integer, String> succeededChunks = new ConcurrentHashMap<Integer, String>();
    private final ConcurrentMap<Integer, String> failedChunks = new ConcurrentHashMap<Integer, String>();
    private final AtomicInteger processedChunks = new AtomicInteger(0);
    private final int totalChunks;
    private final ActionListener<ChunkResult> progressListener;

    public ChunkProcessingContext(int totalChunks, ActionListener<ChunkResult> progressListener) {
        this.totalChunks = totalChunks;
        this.progressListener = progressListener;
    }

    public void handleSuccess(int chunkIndex, String response) {
        this.succeededChunks.put(chunkIndex, response);
        this.completeChunk(chunkIndex);
    }

    public void handleFailure(int chunkIndex, Exception error) {
        this.failedChunks.put(chunkIndex, error.getMessage());
        this.completeChunk(chunkIndex);
    }

    private void completeChunk(int chunkIndex) {
        try {
            int processed = this.processedChunks.incrementAndGet();
            boolean isLastChunk = processed == this.totalChunks;
            ChunkResult result = new ChunkResult(chunkIndex, this.totalChunks, isLastChunk, this.succeededChunks, this.failedChunks);
            this.progressListener.onResponse((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("Error handling chunk completion for chunk {}", (Object)chunkIndex, (Object)e);
            this.progressListener.onFailure(e);
        }
    }
}

