/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.impl;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import org.intellij.images.ImagesBundle;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.thumbnail.ThumbnailManager;
import org.intellij.images.thumbnail.ThumbnailView;
import org.jetbrains.annotations.NotNull;

final class ThumbnailSelectInTarget
implements SelectInTarget,
DumbAware {
    ThumbnailSelectInTarget() {
    }

    public boolean isAvailable(@NotNull Project project) {
        if (project == null) {
            ThumbnailSelectInTarget.$$$reportNull$$$0(0);
        }
        return Registry.is((String)"thumbnails.toolwindow.enabled", (boolean)false);
    }

    public boolean canSelect(SelectInContext context) {
        VirtualFile virtualFile = context.getVirtualFile();
        return ImageFileTypeManager.getInstance().isImage(virtualFile) && virtualFile.getParent() != null;
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        VirtualFile virtualFile = context.getVirtualFile();
        VirtualFile parent = virtualFile.getParent();
        if (parent != null) {
            Project project = context.getProject();
            ThumbnailView thumbnailView = ThumbnailManager.getManager(project).getThumbnailView();
            thumbnailView.setRoot(parent);
            thumbnailView.setVisible(true);
            thumbnailView.setSelected(virtualFile);
            thumbnailView.scrollToSelection();
        }
    }

    public String toString() {
        return ImagesBundle.message("thumbnails.toolwindow.name", new Object[0]);
    }

    public String getToolWindowId() {
        return "Thumbnails";
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 10.0f;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/images/thumbnail/impl/ThumbnailSelectInTarget", "isAvailable"));
    }
}

