/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.parser.AbstractParsing;

public class NameClassParsing
extends AbstractParsing {
    public NameClassParsing(PsiBuilder builder) {
        super(builder);
    }

    public boolean parseNameClass() {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (!this.parseNameClassPart()) {
            marker.drop();
            return false;
        }
        if (this.currentToken() == RncTokenTypes.PIPE) {
            do {
                this.advance();
                if (this.parseNameClassPart()) continue;
                this.error(RelaxngBundle.message("relaxng.parse.error.name-class-expected", new Object[0]));
            } while (this.currentToken() == RncTokenTypes.PIPE);
            marker.done(RncElementTypes.NAME_CLASS_CHOICE);
        } else {
            marker.drop();
        }
        return true;
    }

    private boolean parseNameClassPart() {
        IElementType t = this.currentToken();
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (RncTokenTypes.IDENTIFIER_OR_KEYWORD.contains(t)) {
            this.advance();
        } else if (RncTokenTypes.PREFIXED_NAME == t) {
            this.makeName();
        } else if (RncTokenTypes.STAR == t) {
            this.advance();
            this.parseExceptNameClass();
        } else if (RncTokenTypes.PREFIXED_STAR == t) {
            this.makeName();
            this.parseExceptNameClass();
        } else if (RncTokenTypes.LPAREN == t) {
            this.advance();
            if (this.parseNameClass()) {
                this.match(RncTokenTypes.RPAREN, RelaxngBundle.message("relaxng.parse.error.rparen-expected", new Object[0]));
            }
        } else {
            marker.drop();
            return false;
        }
        marker.done(RncElementTypes.NAME_CLASS);
        return true;
    }

    private void parseExceptNameClass() {
        if (RncTokenTypes.MINUS == this.currentToken()) {
            PsiBuilder.Marker marker = this.begin();
            if (!this.parseNameClass()) {
                this.error(RelaxngBundle.message("relaxng.parse.error.name-class-expected", new Object[0]));
            }
            marker.done(RncElementTypes.EXCEPT_NAME_CLASS);
        }
    }
}

