/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.VideoPromoComponent;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.StartupUiUtil;
import icons.QodanaIcons;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.cloud.QodanaCloudDefaultUrls;
import org.jetbrains.qodana.cloud.QodanaCloudDefaultUrlsKt;
import org.jetbrains.qodana.ui.ComponentsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0014\u0010\u000f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u001a2\u0010\u0013\u001a\u00020\u0012*\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0014\u0010\u000f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u001a-\u0010\u0016\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0013\u0010\u0019\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u00030\u001aH\u0002\u001a\u0014\u0010\u001b\u001a\u00020\u0012*\u00020\u00142\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u001a\n\u0010\u001e\u001a\u00020\u0012*\u00020\u0014\u001a\u0014\u0010\u001f\u001a\u00020\u0012*\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"\"\u001e\u0010\u0000\u001a\f0\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\u0002\b\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001e\u0010\u0006\u001a\f0\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\u0002\b\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0005\"\u001e\u0010\b\u001a\f0\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\u0002\b\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0005\u00a8\u0006#"}, d2={"QODANA_PROMO_URL", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getQODANA_PROMO_URL", "()Ljava/lang/String;", "QODANA_HELP_URL", "getQODANA_HELP_URL", "QODANA_PREVIEW_URL", "getQODANA_PREVIEW_URL", "buildSettingsLogInPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "server", "logInAction", "Lkotlin/Function1;", "Lcom/intellij/util/Url;", "", "logInPanel", "Lcom/intellij/ui/dsl/builder/Panel;", "initialServer", "addServerFieldValidation", "serverNameField", "Lcom/intellij/ui/components/JBTextField;", "errorMessageFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "qodanaPromo", "maxLineLength", "", "qodanaPromoBanner", "setContentAndRepaint", "Lcom/intellij/ui/components/panels/Wrapper;", "wrapped", "Ljavax/swing/JComponent;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\ncomponents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 components.kt\norg/jetbrains/qodana/ui/ComponentsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class ComponentsKt {
    @NotNull
    private static final String QODANA_PROMO_URL;
    @NotNull
    private static final String QODANA_HELP_URL;
    @NotNull
    private static final String QODANA_PREVIEW_URL;

    @NotNull
    public static final String getQODANA_PROMO_URL() {
        return QODANA_PROMO_URL;
    }

    @NotNull
    public static final String getQODANA_HELP_URL() {
        return QODANA_HELP_URL;
    }

    @NotNull
    public static final String getQODANA_PREVIEW_URL() {
        return QODANA_PREVIEW_URL;
    }

    @NotNull
    public static final DialogPanel buildSettingsLogInPanel(@NotNull CoroutineScope scope2, @Nullable String server, @NotNull Function1<? super Url, Unit> logInAction) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter(logInAction, (String)"logInAction");
        return BuilderKt.panel(arg_0 -> ComponentsKt.buildSettingsLogInPanel$lambda$0(scope2, server, logInAction, arg_0));
    }

    public static final void logInPanel(@NotNull Panel $this$logInPanel, @NotNull CoroutineScope scope2, @Nullable String initialServer, @NotNull Function1<? super Url, Unit> logInAction) {
        JBTextField jBTextField;
        Intrinsics.checkNotNullParameter((Object)$this$logInPanel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter(logInAction, (String)"logInAction");
        MutableStateFlow errorMessageFlow = StateFlowKt.MutableStateFlow(null);
        String defaultUrl = QodanaCloudDefaultUrls.INSTANCE.getWebsiteHost();
        JBTextField $this$logInPanel_u24lambda_u241 = jBTextField = new JBTextField(30);
        boolean bl = false;
        $this$logInPanel_u24lambda_u241.getEmptyText().setText(QodanaBundle.message("qodana.settings.panel.organization.url.template", new Object[0]));
        String string = initialServer;
        if (string == null) {
            string = defaultUrl;
        }
        $this$logInPanel_u24lambda_u241.setText(string);
        JBTextField serverNameField = jBTextField;
        Panel.row$default((Panel)$this$logInPanel, null, ComponentsKt::logInPanel$lambda$3, (int)1, null);
        Panel.row$default((Panel)$this$logInPanel, null, arg_0 -> ComponentsKt.logInPanel$lambda$7(serverNameField, defaultUrl, logInAction, errorMessageFlow, arg_0), (int)1, null);
        DialogPanel selfHostedBlock = BuilderKt.panel(arg_0 -> ComponentsKt.logInPanel$lambda$9(serverNameField, arg_0));
        Panel.row$default((Panel)$this$logInPanel, null, arg_0 -> ComponentsKt.logInPanel$lambda$11(selfHostedBlock, arg_0), (int)1, null);
        ComponentsKt.addServerFieldValidation(scope2, serverNameField, (MutableStateFlow<String>)errorMessageFlow);
    }

    private static final void addServerFieldValidation(CoroutineScope scope2, JBTextField serverNameField, MutableStateFlow<String> errorMessageFlow) {
        serverNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(errorMessageFlow){
            final /* synthetic */ MutableStateFlow<String> $errorMessageFlow;
            {
                this.$errorMessageFlow = $errorMessageFlow;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$errorMessageFlow.setValue(null);
            }
        });
        BuildersKt.launch$default((CoroutineScope)scope2, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(serverNameField, errorMessageFlow, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ JBTextField $serverNameField;
            final /* synthetic */ MutableStateFlow<String> $errorMessageFlow;
            {
                this.$serverNameField = $serverNameField;
                this.$errorMessageFlow = $errorMessageFlow;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Disposable disposable = Disposer.newDisposable();
                        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
                        Disposable validatorDisposable = disposable;
                        ComponentValidator validator = new ComponentValidator(validatorDisposable).installOn((JComponent)this.$serverNameField);
                        this.L$0 = validatorDisposable;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)validator);
                        this.label = 1;
                        Object object2 = this.$errorMessageFlow.collect(new FlowCollector(validator, this.$serverNameField){
                            final /* synthetic */ ComponentValidator $validator;
                            final /* synthetic */ JBTextField $serverNameField;
                            {
                                this.$validator = $validator;
                                this.$serverNameField = $serverNameField;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object emit(String errorMessage, Continuation<? super Unit> $completion) {
                                ValidationInfo validationInfo;
                                ComponentValidator componentValidator = this.$validator;
                                String string = errorMessage;
                                if (string != null) {
                                    void it;
                                    String string2 = string;
                                    JBTextField jBTextField = this.$serverNameField;
                                    String string3 = string2;
                                    ComponentValidator componentValidator2 = componentValidator;
                                    boolean bl = false;
                                    validationInfo = new ValidationInfo((String)it, (JComponent)jBTextField);
                                    componentValidator = componentValidator2;
                                } else {
                                    validationInfo = null;
                                }
                                componentValidator.updateInfo(validationInfo);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        Object object2;
                        ComponentValidator validator = (ComponentValidator)this.L$1;
                        Disposable validatorDisposable = (Disposable)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            throw new KotlinNothingValueException();
                        }
                        catch (Throwable throwable) {
                            Disposer.dispose((Disposable)validatorDisposable);
                            throw throwable;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final void qodanaPromo(@NotNull Panel $this$qodanaPromo, int maxLineLength) {
        Intrinsics.checkNotNullParameter((Object)$this$qodanaPromo, (String)"<this>");
        Panel.row$default((Panel)$this$qodanaPromo, null, ComponentsKt::qodanaPromo$lambda$12, (int)1, null);
        Panel.row$default((Panel)$this$qodanaPromo, null, arg_0 -> ComponentsKt.qodanaPromo$lambda$13(maxLineLength, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$qodanaPromo, null, ComponentsKt::qodanaPromo$lambda$14, (int)1, null);
    }

    public static /* synthetic */ void qodanaPromo$default(Panel panel, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        ComponentsKt.qodanaPromo(panel, n);
    }

    public static final void qodanaPromoBanner(@NotNull Panel $this$qodanaPromoBanner) {
        Intrinsics.checkNotNullParameter((Object)$this$qodanaPromoBanner, (String)"<this>");
        VideoPromoComponent qodanaPreview2 = new VideoPromoComponent((JComponent)new JLabel(QodanaIcons.Images.QodanaVideoPreview), QodanaBundle.message("qodana.promo.banner.watch.overview", new Object[0]), true, StartupUiUtil.isUnderDarcula(), (Runnable)qodanaPromoBanner.qodanaPreview.1.INSTANCE);
        Panel.row$default((Panel)$this$qodanaPromoBanner, null, arg_0 -> ComponentsKt.qodanaPromoBanner$lambda$15(qodanaPreview2, arg_0), (int)1, null);
    }

    public static final void setContentAndRepaint(@NotNull Wrapper $this$setContentAndRepaint, @Nullable JComponent wrapped) {
        Intrinsics.checkNotNullParameter((Object)$this$setContentAndRepaint, (String)"<this>");
        JComponent oldWrapped = $this$setContentAndRepaint.getTargetComponent();
        $this$setContentAndRepaint.setContent(wrapped);
        if (!Intrinsics.areEqual((Object)oldWrapped, (Object)wrapped)) {
            $this$setContentAndRepaint.repaint();
        }
    }

    private static final Unit buildSettingsLogInPanel$lambda$0(CoroutineScope $scope, String $server, Function1 $logInAction, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        ComponentsKt.logInPanel($this$panel, $scope, $server, (Function1<? super Url, Unit>)$logInAction);
        Panel.separator$default((Panel)$this$panel, null, (int)1, null).bottomGap(BottomGap.SMALL);
        ComponentsKt.qodanaPromo$default($this$panel, 0, 1, null);
        ComponentsKt.qodanaPromoBanner($this$panel);
        return Unit.INSTANCE;
    }

    private static final Unit logInPanel$lambda$3$lambda$2(JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setFont((Font)JBFont.label().biggerOn(3.0f));
        return Unit.INSTANCE;
    }

    private static final Unit logInPanel$lambda$3(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = QodanaBundle.message("qodana.settings.panel.log.in.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string).applyToComponent(ComponentsKt::logInPanel$lambda$3$lambda$2);
        return Unit.INSTANCE;
    }

    private static final Unit logInPanel$lambda$7$lambda$5(JBTextField $serverNameField, String $defaultUrl, Function1 $logInAction, MutableStateFlow $errorMessageFlow, ActionEvent it) {
        Url url;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String serverName = $serverNameField.getText();
        Intrinsics.checkNotNull((Object)serverName);
        if (((CharSequence)serverName).length() == 0 || Intrinsics.areEqual((Object)serverName, (Object)$defaultUrl)) {
            url = null;
        } else {
            Url url2;
            try {
                url2 = Urls.newFromEncoded((String)QodanaCloudDefaultUrlsKt.normalizeUrl(serverName));
            }
            catch (MalformedURLException e) {
                String string = e.getMessage();
                if (string != null) {
                    String it2 = string;
                    boolean bl = false;
                    $errorMessageFlow.setValue((Object)QodanaBundle.message("qodana.settings.panel.organization.url.another.error", new Object[0]));
                }
                return Unit.INSTANCE;
            }
            url = url2;
        }
        Url url3 = url;
        $logInAction.invoke(url3);
        return Unit.INSTANCE;
    }

    private static final Unit logInPanel$lambda$7(JBTextField $serverNameField, String $defaultUrl, Function1 $logInAction, MutableStateFlow $errorMessageFlow, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = QodanaBundle.message("qodana.settings.panel.log.in.button", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell $this$logInPanel_u24lambda_u247_u24lambda_u246 = cell = $this$row.button(string, arg_0 -> ComponentsKt.logInPanel$lambda$7$lambda$5($serverNameField, $defaultUrl, $logInAction, $errorMessageFlow, arg_0));
        boolean bl = false;
        ((JButton)$this$logInPanel_u24lambda_u247_u24lambda_u246.getComponent()).putClientProperty(DslComponentProperty.VISUAL_PADDINGS, UnscaledGaps.EMPTY);
        return Unit.INSTANCE;
    }

    private static final Unit logInPanel$lambda$9$lambda$8(JBTextField $serverNameField, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$serverNameField);
        return Unit.INSTANCE;
    }

    private static final Unit logInPanel$lambda$9(JBTextField $serverNameField, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = QodanaBundle.message("qodana.settings.panel.organization.url", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> ComponentsKt.logInPanel$lambda$9$lambda$8($serverNameField, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit logInPanel$lambda$11(DialogPanel $selfHostedBlock, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell $this$logInPanel_u24lambda_u2411_u24lambda_u2410 = cell = $this$row.cell((JComponent)$selfHostedBlock);
        boolean bl = false;
        ((DialogPanel)$this$logInPanel_u24lambda_u2411_u24lambda_u2410.getComponent()).putClientProperty((Object)DslComponentProperty.VISUAL_PADDINGS, (Object)UnscaledGaps.EMPTY);
        return Unit.INSTANCE;
    }

    private static final Unit qodanaPromo$lambda$12(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon = QodanaIcons.Images.Qodana;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Qodana");
        $this$row.icon(icon);
        return Unit.INSTANCE;
    }

    private static final Unit qodanaPromo$lambda$13(int $maxLineLength, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = QodanaBundle.message("qodana.promo.text.full", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.text$default((Row)$this$row, (String)string, (int)$maxLineLength, null, (int)4, null);
        return Unit.INSTANCE;
    }

    private static final Unit qodanaPromo$lambda$14(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = QodanaBundle.message("qodana.explore.promo.button", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.browserLink(string, QODANA_PROMO_URL);
        return Unit.INSTANCE;
    }

    private static final Unit qodanaPromoBanner$lambda$15(VideoPromoComponent $qodanaPreview, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$qodanaPreview);
        return Unit.INSTANCE;
    }

    static {
        String string = QodanaBundle.message("qodana.website.url", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        QODANA_PROMO_URL = string;
        String string2 = QodanaBundle.message("qodana.documentation.ide.plugin.url", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        QODANA_HELP_URL = string2;
        String string3 = QodanaBundle.message("qodana.preview.url", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        QODANA_PREVIEW_URL = string3;
    }
}

