/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css2;

import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css1.Css1Style;
import org.w3c.css.properties.css2.CssBackgroundAttachment;
import org.w3c.css.properties.css2.CssBackgroundColor;
import org.w3c.css.properties.css2.CssBackgroundImage;
import org.w3c.css.properties.css2.CssBackgroundPosition;
import org.w3c.css.properties.css2.CssBackgroundRepeat;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class CssBackground
extends org.w3c.css.properties.css.CssBackground {
    public CssBackgroundColor color;
    public CssBackgroundImage image;
    public CssBackgroundRepeat repeat;
    public CssBackgroundAttachment attachment;
    public CssBackgroundPosition position;
    public boolean same;

    @Override
    public CssProperty duplicate() {
        CssBackground cloned = (CssBackground)super.duplicate();
        if (cloned != null) {
            if (this.color != null) {
                cloned.color = (CssBackgroundColor)this.color.duplicate();
            }
            if (this.image != null) {
                cloned.image = (CssBackgroundImage)this.image.duplicate();
            }
            if (this.repeat != null) {
                cloned.repeat = (CssBackgroundRepeat)this.repeat.duplicate();
            }
            if (this.attachment != null) {
                cloned.attachment = (CssBackgroundAttachment)this.attachment.duplicate();
            }
            if (this.position != null) {
                cloned.position = (CssBackgroundPosition)this.position.duplicate();
            }
        }
        return cloned;
    }

    public CssBackground() {
    }

    public CssBackground(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        CssValue val;
        boolean manyValues;
        char op = ' ';
        boolean find = true;
        CssExpression background_position_expression = null;
        if (check && expression.getCount() > 6) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        boolean bl = manyValues = expression.getCount() > 1;
        block9: while (find && (val = expression.getValue()) != null) {
            op = expression.getOperator();
            if (manyValues && val.equals(inherit)) {
                throw new InvalidParamException("unrecognize", null, null, ac);
            }
            switch (val.getType()) {
                case 1: {
                    if (check) {
                        throw new InvalidParamException("unrecognize", ac);
                    }
                    find = false;
                    break;
                }
                case 2: {
                    if (this.getImage() == null) {
                        this.setImage(new CssBackgroundImage(ac, expression));
                        continue block9;
                    }
                    find = false;
                    break;
                }
                case 3: 
                case 15: {
                    if (this.getColor2() == null) {
                        this.setColor(new CssBackgroundColor(ac, expression));
                        continue block9;
                    }
                    find = false;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    if (background_position_expression == null) {
                        background_position_expression = new CssExpression();
                    }
                    background_position_expression.addValue(val);
                    expression.next();
                    find = true;
                    break;
                }
                case 0: {
                    find = false;
                    CssIdent identval = (CssIdent)val;
                    if (inherit.equals(identval) && !manyValues) {
                        find = true;
                        this.same = true;
                        expression.next();
                        break;
                    }
                    if (CssBackgroundImage.checkMatchingIdent(identval)) {
                        if (this.getImage() != null) break;
                        this.setImage(new CssBackgroundImage(ac, expression));
                        find = true;
                        break;
                    }
                    if (CssBackgroundRepeat.checkMatchingIdent(identval)) {
                        if (this.getRepeat() != null) break;
                        this.setRepeat(new CssBackgroundRepeat(ac, expression));
                        find = true;
                        break;
                    }
                    if (CssBackgroundAttachment.checkMatchingIdent(identval)) {
                        if (this.getAttachment() != null) break;
                        this.setAttachment(new CssBackgroundAttachment(ac, expression));
                        find = true;
                        break;
                    }
                    if (CssBackgroundPosition.checkMatchingIdent(identval)) {
                        if (background_position_expression == null) {
                            background_position_expression = new CssExpression();
                        }
                        background_position_expression.addValue(val);
                        expression.next();
                        find = true;
                        break;
                    }
                    if (this.getColor2() == null) {
                        try {
                            this.setColor(new CssBackgroundColor(ac, expression));
                            find = true;
                            break;
                        }
                        catch (InvalidParamException invalidParamException) {
                            // empty catch block
                        }
                    }
                }
                default: {
                    if (check) {
                        throw new InvalidParamException("unrecognize", ac);
                    }
                    find = false;
                }
            }
            if (check && !find) {
                throw new InvalidParamException("unrecognize", ac);
            }
            if (op == 32) continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        if (background_position_expression != null) {
            this.setPosition(new CssBackgroundPosition(ac, background_position_expression, check));
        }
    }

    public CssBackground(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public CssBackgroundAttachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(CssBackgroundAttachment attachment) {
        this.attachment = attachment;
    }

    public CssBackgroundImage getImage() {
        return this.image;
    }

    public void setImage(CssBackgroundImage image) {
        this.image = image;
    }

    public CssBackgroundRepeat getRepeat() {
        return this.repeat;
    }

    public void setRepeat(CssBackgroundRepeat repeat) {
        this.repeat = repeat;
    }

    public boolean isSame() {
        return this.same;
    }

    public void setSame(boolean same) {
        this.same = same;
    }

    public final CssBackgroundColor getColor2() {
        return this.color;
    }

    public void setColor(CssBackgroundColor color) {
        this.color = color;
    }

    public CssBackgroundPosition getPosition() {
        return this.position;
    }

    public void setPosition(CssBackgroundPosition position) {
        this.position = position;
    }

    @Override
    public Object get() {
        return this.color;
    }

    @Override
    public final CssValue getColor() {
        if (this.color == null) {
            return null;
        }
        return this.color.getColor();
    }

    @Override
    public String toString() {
        if (this.same) {
            return inherit.toString();
        }
        StringBuilder sb = new StringBuilder();
        boolean addspace = false;
        if (this.color != null) {
            sb.append(this.color);
            addspace = true;
        }
        if (this.image != null) {
            if (addspace) {
                sb.append(' ');
            }
            sb.append(this.image);
            addspace = true;
        }
        if (this.repeat != null) {
            if (addspace) {
                sb.append(' ');
            }
            sb.append(this.repeat);
            addspace = true;
        }
        if (this.attachment != null) {
            if (addspace) {
                sb.append(' ');
            }
            sb.append(this.attachment);
            addspace = true;
        }
        if (this.position != null) {
            if (addspace) {
                sb.append(' ');
            }
            sb.append(this.position);
        }
        return sb.toString();
    }

    @Override
    public void setImportant() {
        this.important = true;
        if (this.color != null) {
            this.color.important = true;
        }
        if (this.image != null) {
            this.image.important = true;
        }
        if (this.repeat != null) {
            this.repeat.important = true;
        }
        if (this.attachment != null) {
            this.attachment.important = true;
        }
        if (this.position != null) {
            this.position.important = true;
        }
    }

    @Override
    public boolean getImportant() {
        if (this.same) {
            return this.important;
        }
        return !(this.color != null && !this.color.important || this.image != null && !this.image.important || this.repeat != null && !this.repeat.important || this.attachment != null && !this.attachment.important || this.position != null && !this.position.important);
    }

    @Override
    public void setSelectors(CssSelectors selector) {
        super.setSelectors(selector);
        if (this.color != null) {
            this.color.setSelectors(selector);
        }
        if (this.image != null) {
            this.image.setSelectors(selector);
        }
        if (this.repeat != null) {
            this.repeat.setSelectors(selector);
        }
        if (this.attachment != null) {
            this.attachment.setSelectors(selector);
        }
        if (this.position != null) {
            this.position.setSelectors(selector);
        }
    }

    @Override
    public void addToStyle(ApplContext ac, CssStyle style) {
        ((Css1Style)style).cssBackground.same = this.same;
        ((Css1Style)style).cssBackground.byUser = this.byUser;
        if (this.color != null) {
            this.color.addToStyle(ac, style);
        }
        if (this.image != null) {
            this.image.addToStyle(ac, style);
        }
        if (this.repeat != null) {
            this.repeat.addToStyle(ac, style);
        }
        if (this.attachment != null) {
            this.attachment.addToStyle(ac, style);
        }
        if (this.position != null) {
            this.position.addToStyle(ac, style);
        }
    }

    @Override
    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css1Style)style).getBackground();
        }
        return ((Css1Style)style).cssBackground;
    }

    @Override
    public boolean equals(CssProperty property) {
        return false;
    }

    @Override
    public void setInfo(int line, String source) {
        super.setInfo(line, source);
        if (this.color != null) {
            this.color.setInfo(line, source);
        }
        if (this.image != null) {
            this.image.setInfo(line, source);
        }
        if (this.repeat != null) {
            this.repeat.setInfo(line, source);
        }
        if (this.attachment != null) {
            this.attachment.setInfo(line, source);
        }
        if (this.position != null) {
            this.position.setInfo(line, source);
        }
    }
}

