/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.critic;

import ca.sqlpower.architect.ddl.critic.CriticAndSettings;
import ca.sqlpower.architect.ddl.critic.Criticism;
import ca.sqlpower.architect.ddl.critic.CriticismBucket;
import ca.sqlpower.architect.ddl.critic.CriticismEvent;
import ca.sqlpower.architect.ddl.critic.CriticismListener;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class CriticismTableModel
extends AbstractTableModel {
    private final CriticismBucket criticizer;
    private final CriticismListener criticListener = new CriticismListener(){

        @Override
        public void criticismRemoved(CriticismEvent e) {
            CriticismTableModel.this.fireTableRowsDeleted(e.getIndex(), e.getIndex());
        }

        @Override
        public void criticismAdded(CriticismEvent e) {
            CriticismTableModel.this.fireTableRowsInserted(e.getIndex(), e.getIndex());
        }
    };

    public CriticismTableModel(ArchitectSwingSession session, CriticismBucket criticizer) {
        this.criticizer = criticizer;
        criticizer.addCriticismListener(this.criticListener);
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 1) {
            return "Object";
        }
        if (column == 2) {
            return "Critic Type";
        }
        if (column == 3) {
            return "Description";
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return CriticAndSettings.Severity.class;
        }
        if (columnIndex == 1) {
            return Object.class;
        }
        if (columnIndex == 2) {
            return String.class;
        }
        if (columnIndex == 3) {
            return String.class;
        }
        if (columnIndex == 4) {
            return List.class;
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.criticizer.getCriticisms().size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == -1 || rowIndex == -1) {
            return null;
        }
        Criticism rowVal = this.criticizer.getCriticisms().get(rowIndex);
        if (columnIndex == 0) {
            return rowVal.getCritic().getSeverity();
        }
        if (columnIndex == 1) {
            return rowVal.getSubject();
        }
        if (columnIndex == 2) {
            return ((CriticAndSettings)rowVal.getCritic()).getPlatformType();
        }
        if (columnIndex == 3) {
            return rowVal.getDescription();
        }
        if (columnIndex == 4) {
            return rowVal.getFixes();
        }
        throw new IllegalArgumentException("This table has " + this.getColumnCount() + " columns, and I " + "was asked for column " + columnIndex);
    }
}

