/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.actions;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSessionRunMode;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSessionRunModeKt;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSettingsKt;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.util.ui.JBFont;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/actions/KotlinNotebookSessionModeComboBox;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getRunMode", "Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookSessionRunMode;", "Lcom/intellij/openapi/actionSystem/DataContext;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "createCustomComponentForResultViewToolbar", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.kotlin.jupyter.core"})
public final class KotlinNotebookSessionModeComboBox
extends DumbAwareAction
implements CustomComponentAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!KotlinNotebookSessionRunModeKt.isKernelRunModeSelectionEnabled()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        KotlinNotebookSessionRunMode runMode = this.getRunMode(dataContext);
        if (runMode == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setText(runMode.getTitle());
    }

    private final KotlinNotebookSessionRunMode getRunMode(DataContext $this$getRunMode) {
        BackedNotebookVirtualFile notebookFile;
        BackedNotebookVirtualFile backedNotebookVirtualFile = notebookFile = JupyterDataContextExtensionsKt.getNotebookFile((DataContext)$this$getRunMode);
        if (!(backedNotebookVirtualFile != null ? IsKotlinNotebookKt.isKotlinNotebook(backedNotebookVirtualFile) : false)) {
            return null;
        }
        JupyterNotebook jupyterNotebook = notebookFile.getNotebookOrNull();
        if (jupyterNotebook == null) {
            return null;
        }
        JupyterNotebook notebook = jupyterNotebook;
        return KotlinNotebookSettingsKt.readSettings(notebook).getSessionRunMode();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JComponent jComponent = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
        if (jComponent == null) {
            return;
        }
        Component component = jComponent;
        JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
        AnAction anAction = ActionManager.getInstance().getAction("KotlinNotebookChangeSessionModeActions");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ListPopup listPopup = jBPopupFactory.createActionGroupPopup(null, (ActionGroup)anAction, e.getDataContext(), null, true, null);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        JBPopup popup = (JBPopup)listPopup;
        popup.showUnderneathOf(component);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        return this.createCustomComponentForResultViewToolbar((AnAction)this, presentation, place);
    }

    private final JComponent createCustomComponentForResultViewToolbar(AnAction action, Presentation presentation, String place) {
        Dimension dimension = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE;
        ActionButtonWithText button2 = new ActionButtonWithText(action, presentation, place, dimension){

            protected boolean shallPaintDownArrow() {
                return true;
            }
        };
        button2.setHorizontalTextAlignment(2);
        button2.setFont((Font)JBFont.small());
        return (JComponent)button2;
    }
}

