/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.lower;

import androidx.compose.compiler.plugins.kotlin.lower.CaptureCollector;
import androidx.compose.compiler.plugins.kotlin.lower.DeclarationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u000eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0015H\u0016J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0015H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000b\u00a8\u0006$"}, d2={"Landroidx/compose/compiler/plugins/kotlin/lower/FunctionContext;", "Landroidx/compose/compiler/plugins/kotlin/lower/DeclarationContext;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "composable", "", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Z)V", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getComposable", "()Z", "locals", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "getLocals", "()Ljava/util/Set;", "captures", "getCaptures", "collectors", "", "Landroidx/compose/compiler/plugins/kotlin/lower/CaptureCollector;", "getCollectors", "()Ljava/util/List;", "setCollectors", "(Ljava/util/List;)V", "canRemember", "getCanRemember", "declareLocal", "", "local", "recordCapture", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "pushCollector", "collector", "popCollector", "kotlin-compose-compiler-plugin"})
@SourceDebugExtension(value={"SMAP\nComposerLambdaMemoization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposerLambdaMemoization.kt\nandroidx/compose/compiler/plugins/kotlin/lower/FunctionContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1218:1\n1869#2,2:1219\n*S KotlinDebug\n*F\n+ 1 ComposerLambdaMemoization.kt\nandroidx/compose/compiler/plugins/kotlin/lower/FunctionContext\n*L\n139#1:1219,2\n*E\n"})
final class FunctionContext
extends DeclarationContext {
    @NotNull
    private final IrFunction declaration;
    private final boolean composable;
    @NotNull
    private final Set<IrValueDeclaration> locals;
    @NotNull
    private final Set<IrValueDeclaration> captures;
    @NotNull
    private List<CaptureCollector> collectors;

    public FunctionContext(@NotNull IrFunction declaration, boolean composable) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.declaration = declaration;
        this.composable = composable;
        this.locals = new LinkedHashSet();
        this.captures = new LinkedHashSet();
        this.collectors = new ArrayList();
        Iterable $this$forEach$iv = this.getDeclaration().getParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl = false;
            this.declareLocal((IrValueDeclaration)it);
        }
    }

    @NotNull
    public IrFunction getDeclaration() {
        return this.declaration;
    }

    @Override
    public boolean getComposable() {
        return this.composable;
    }

    @NotNull
    public final Set<IrValueDeclaration> getLocals() {
        return this.locals;
    }

    @Override
    @NotNull
    public Set<IrValueDeclaration> getCaptures() {
        return this.captures;
    }

    @NotNull
    public final List<CaptureCollector> getCollectors() {
        return this.collectors;
    }

    public final void setCollectors(@NotNull List<CaptureCollector> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.collectors = list;
    }

    public final boolean getCanRemember() {
        return this.getComposable();
    }

    @Override
    public void declareLocal(@NotNull IrValueDeclaration local) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        this.locals.add(local);
    }

    @Override
    public boolean recordCapture(@NotNull IrValueDeclaration local) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        boolean containsLocal = this.locals.contains(local);
        if (!((Collection)this.collectors).isEmpty() && containsLocal) {
            for (CaptureCollector collector : this.collectors) {
                collector.recordCapture(local);
            }
        }
        if (AdditionalIrUtilsKt.isLocal((IrDeclaration)((IrDeclaration)this.getDeclaration())) && !containsLocal) {
            this.getCaptures().add(local);
        }
        return containsLocal;
    }

    @Override
    public void recordCapture(@NotNull IrSymbolOwner local) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        Set<IrValueDeclaration> captures = this.getLocalDeclarationCaptures().get(local);
        for (CaptureCollector collector : this.collectors) {
            collector.recordCapture(local);
            if (captures == null) continue;
            for (IrValueDeclaration capture : captures) {
                collector.recordCapture(capture);
            }
        }
    }

    @Override
    public void pushCollector(@NotNull CaptureCollector collector) {
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        this.collectors.add(collector);
    }

    @Override
    public void popCollector(@NotNull CaptureCollector collector) {
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        if (!Intrinsics.areEqual((Object)CollectionsKt.lastOrNull(this.collectors), (Object)collector)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.collectors.remove(this.collectors.size() - 1);
    }
}

