/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ParentAwareTokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingLoopBodyFixer
implements Fixer {
    @Override
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        ASTNode body;
        ASTNode loopStatement;
        if (astNode == null) {
            MissingLoopBodyFixer.$$$reportNull$$$0(0);
        }
        if ((loopStatement = MissingLoopBodyFixer.getLoopParent(astNode)) == null) {
            return;
        }
        Document doc = editor.getDocument();
        if (BasicJavaAstTreeUtil.is(loopStatement, BasicJavaElementType.BASIC_FOR_STATEMENT)) {
            body = BasicJavaAstTreeUtil.getForBody(loopStatement);
        } else if (BasicJavaAstTreeUtil.is(loopStatement, BasicJavaElementType.BASIC_FOREACH_STATEMENT)) {
            body = BasicJavaAstTreeUtil.getForeachBody(loopStatement);
        } else if (BasicJavaAstTreeUtil.is(loopStatement, BasicJavaElementType.BASIC_WHILE_STATEMENT)) {
            body = BasicJavaAstTreeUtil.getWhileBody(loopStatement);
        } else {
            return;
        }
        if (BasicJavaAstTreeUtil.is(body, BasicJavaElementType.BASIC_BLOCK_STATEMENT)) {
            return;
        }
        if (body != null && MissingLoopBodyFixer.startLine(doc, body) == MissingLoopBodyFixer.startLine(doc, loopStatement)) {
            return;
        }
        MissingLoopBodyFixer.fixLoopBody(editor, processor, loopStatement, doc, body);
    }

    private static ASTNode getLoopParent(@NotNull ASTNode element) {
        ASTNode statement;
        if (element == null) {
            MissingLoopBodyFixer.$$$reportNull$$$0(1);
        }
        if ((statement = BasicJavaAstTreeUtil.getParentOfType(element, ParentAwareTokenSet.create((IElementType[])new IElementType[]{BasicJavaElementType.BASIC_FOREACH_STATEMENT, BasicJavaElementType.BASIC_FOR_STATEMENT, BasicJavaElementType.BASIC_WHILE_STATEMENT}))) == null) {
            return null;
        }
        if (BasicJavaAstTreeUtil.is(statement, BasicJavaElementType.BASIC_FOREACH_STATEMENT)) {
            return MissingLoopBodyFixer.isForEachApplicable(statement, element) ? statement : null;
        }
        if (BasicJavaAstTreeUtil.is(statement, BasicJavaElementType.BASIC_FOR_STATEMENT)) {
            return MissingLoopBodyFixer.isForApplicable(statement, element) ? statement : null;
        }
        if (BasicJavaAstTreeUtil.is(statement, BasicJavaElementType.BASIC_WHILE_STATEMENT)) {
            return statement;
        }
        return null;
    }

    private static boolean isForApplicable(ASTNode statement, ASTNode astNode) {
        ASTNode init = BasicJavaAstTreeUtil.getForInitialization(statement);
        ASTNode update = BasicJavaAstTreeUtil.getForUpdate(statement);
        ASTNode check = BasicJavaAstTreeUtil.getForCondition(statement);
        return MissingLoopBodyFixer.isValidChild(init, astNode) || MissingLoopBodyFixer.isValidChild(update, astNode) || MissingLoopBodyFixer.isValidChild(check, astNode);
    }

    private static boolean isValidChild(ASTNode ancestorNode, ASTNode node) {
        PsiElement ancestor = BasicJavaAstTreeUtil.toPsi(ancestorNode);
        PsiElement element = BasicJavaAstTreeUtil.toPsi(node);
        if (ancestor != null && element != null && PsiTreeUtil.isAncestor((PsiElement)ancestor, (PsiElement)element, (boolean)false)) {
            return !PsiTreeUtil.hasErrorElements((PsiElement)ancestor);
        }
        return false;
    }

    private static boolean isForEachApplicable(ASTNode statement, ASTNode astNode) {
        ASTNode iterated = BasicJavaAstTreeUtil.getForEachIteratedValue(statement);
        ASTNode parameter = BasicJavaAstTreeUtil.getForEachIterationParameter(statement);
        PsiElement iteratedElement = BasicJavaAstTreeUtil.toPsi(iterated);
        PsiElement parameterElement = BasicJavaAstTreeUtil.toPsi(parameter);
        PsiElement element = BasicJavaAstTreeUtil.toPsi(astNode);
        return element != null && (PsiTreeUtil.isAncestor((PsiElement)iteratedElement, (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)parameterElement, (PsiElement)element, (boolean)false));
    }

    private static int startLine(Document doc, ASTNode astNode) {
        return doc.getLineNumber(astNode.getTextRange().getStartOffset());
    }

    private static void fixLoopBody(@NotNull Editor editor, @NotNull AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode loop, @NotNull Document doc, @Nullable ASTNode body) {
        if (editor == null) {
            MissingLoopBodyFixer.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            MissingLoopBodyFixer.$$$reportNull$$$0(3);
        }
        if (loop == null) {
            MissingLoopBodyFixer.$$$reportNull$$$0(4);
        }
        if (doc == null) {
            MissingLoopBodyFixer.$$$reportNull$$$0(5);
        }
        ASTNode eltToInsertAfter = BasicJavaAstTreeUtil.getRParenth(loop);
        PsiElement loopElement = BasicJavaAstTreeUtil.toPsi(loop);
        if (body != null && eltToInsertAfter != null) {
            PsiElement bodyElement = BasicJavaAstTreeUtil.toPsi(body);
            if (loopElement != null && bodyElement != null && MissingLoopBodyFixer.bodyIsIndented(loopElement, bodyElement)) {
                int endOffset = body.getTextRange().getEndOffset();
                doc.insertString(endOffset, (CharSequence)"\n");
                processor.insertCloseBrace(editor, endOffset + 1);
                int offset = eltToInsertAfter.getTextRange().getEndOffset();
                doc.insertString(offset, (CharSequence)"{");
                editor.getCaretModel().moveToOffset(endOffset + "{".length());
                processor.setSkipEnter(true);
                processor.reformat(loopElement);
                return;
            }
        }
        boolean needToClose = false;
        if (eltToInsertAfter == null) {
            eltToInsertAfter = loop;
            needToClose = true;
        }
        int offset = eltToInsertAfter.getTextRange().getEndOffset();
        if (needToClose) {
            if (BasicJavaAstTreeUtil.getLParenth(loop) == null) {
                doc.insertString(offset, (CharSequence)"()");
                offset += 2;
            } else {
                doc.insertString(offset, (CharSequence)")");
                ++offset;
            }
        }
        processor.insertBraces(editor, offset);
        editor.getCaretModel().moveToOffset(offset);
    }

    private static boolean bodyIsIndented(@NotNull PsiElement loop, @NotNull PsiElement body) {
        PsiWhiteSpace beforeBody;
        if (loop == null) {
            MissingLoopBodyFixer.$$$reportNull$$$0(6);
        }
        if (body == null) {
            MissingLoopBodyFixer.$$$reportNull$$$0(7);
        }
        if ((beforeBody = (PsiWhiteSpace)ObjectUtils.tryCast((Object)body.getPrevSibling(), PsiWhiteSpace.class)) == null) {
            return false;
        }
        PsiWhiteSpace beforeLoop = (PsiWhiteSpace)ObjectUtils.tryCast((Object)loop.getPrevSibling(), PsiWhiteSpace.class);
        if (beforeLoop == null) {
            return false;
        }
        String beforeBodyText = beforeBody.getText();
        String beforeLoopText = beforeLoop.getText();
        int beforeBodyLineBreak = beforeBodyText.lastIndexOf(10);
        if (beforeBodyLineBreak == -1) {
            return false;
        }
        int beforeLoopLineBreak = beforeLoopText.lastIndexOf(10);
        if (beforeLoopLineBreak == -1) {
            return false;
        }
        return beforeBodyText.length() - beforeBodyLineBreak > beforeLoopText.length() - beforeLoopLineBreak;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loop";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/MissingLoopBodyFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLoopParent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fixLoopBody";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "bodyIsIndented";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

