/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async.troubleshooting.report;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.profiler.ultimate.DumpState;
import com.intellij.profiler.ultimate.JavaProfilerErrorContext;
import com.intellij.profiler.ultimate.async.troubleshooting.AsyncProfilerErrorReason;
import com.intellij.profiler.ultimate.async.troubleshooting.report.AsyncProfilerErrorReporter;
import com.intellij.util.containers.UtilKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J&\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J0\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00150\u00142\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0018R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/ultimate/async/troubleshooting/report/LogErrorAsyncProfilerErrorReporter;", "Lcom/intellij/profiler/ultimate/async/troubleshooting/report/AsyncProfilerErrorReporter;", "loggerProvider", "Lkotlin/Function0;", "Lcom/intellij/openapi/diagnostic/Logger;", "logProcessor", "Lkotlin/Function1;", "", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "reportError", "", "info", "Lcom/intellij/profiler/ultimate/JavaProfilerErrorContext;", "log", "reasons", "", "Lcom/intellij/profiler/ultimate/async/troubleshooting/AsyncProfilerErrorReason;", "reportRecover", "prepareMessage", "Lkotlin/Pair;", "", "prepareAttachments", "Lcom/intellij/openapi/diagnostic/Attachment;", "(Ljava/lang/String;)[Lcom/intellij/openapi/diagnostic/Attachment;", "Companion", "intellij.profiler.ultimate"})
public final class LogErrorAsyncProfilerErrorReporter
extends AsyncProfilerErrorReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Logger> loggerProvider;
    @NotNull
    private final Function1<String, String> logProcessor;
    @NotNull
    private static final Function1<String, String> defaultLogProcessor = LogErrorAsyncProfilerErrorReporter::defaultLogProcessor$lambda$3;

    public LogErrorAsyncProfilerErrorReporter(@NotNull Function0<? extends Logger> loggerProvider, @NotNull Function1<? super String, String> logProcessor) {
        Intrinsics.checkNotNullParameter(loggerProvider, (String)"loggerProvider");
        Intrinsics.checkNotNullParameter(logProcessor, (String)"logProcessor");
        this.loggerProvider = loggerProvider;
        this.logProcessor = logProcessor;
    }

    public /* synthetic */ LogErrorAsyncProfilerErrorReporter(Function0 function0, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = defaultLogProcessor;
        }
        this((Function0<? extends Logger>)function0, function1);
    }

    @Override
    public void reportError(@NotNull JavaProfilerErrorContext info, @NotNull String log, @NotNull List<? extends AsyncProfilerErrorReason> reasons) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter(reasons, (String)"reasons");
        Pair<String, String[]> pair = this.prepareMessage(info, reasons);
        String mainLine = (String)pair.component1();
        String[] details = (String[])pair.component2();
        Attachment[] attachments = this.prepareAttachments(log);
        RuntimeExceptionWithAttachments exception = new RuntimeExceptionWithAttachments(mainLine, Arrays.copyOf(attachments, attachments.length));
        ((Logger)this.loggerProvider.invoke()).error(mainLine, (Throwable)exception, Arrays.copyOf(details, details.length));
    }

    @Override
    public void reportRecover(@NotNull JavaProfilerErrorContext info, @NotNull String log, @NotNull List<? extends AsyncProfilerErrorReason> reasons) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter(reasons, (String)"reasons");
        Pair<String, String[]> pair = this.prepareMessage(info, reasons);
        String mainLine = (String)pair.component1();
        String[] details = (String[])pair.component2();
        StringBuilder $this$reportRecover_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$reportRecover_u24lambda_u240.append("Successfully recovered from error. Original message:").append('\n');
        $this$reportRecover_u24lambda_u240.append(mainLine).append('\n');
        for (String detail : details) {
            $this$reportRecover_u24lambda_u240.append(detail).append('\n');
        }
        String message = stringBuilder.toString();
        ((Logger)this.loggerProvider.invoke()).info(message);
    }

    private final Pair<String, String[]> prepareMessage(JavaProfilerErrorContext info, List<? extends AsyncProfilerErrorReason> reasons) {
        List list;
        Object object;
        if (info.getAttachMode()) {
            object = "attach failed";
        } else {
            String stateAsString = switch (WhenMappings.$EnumSwitchMapping$0[info.getDumpState().ordinal()]) {
                case 1 -> "doesn't exist";
                case 2 -> "is empty";
                case 3 -> throw new AssertionError((Object)"Shouldn't reach here");
                default -> throw new NoWhenBranchMatchedException();
            };
            object = "dump file '" + info.getDump() + "' " + stateAsString;
        }
        String mainLine = object;
        List $this$prepareMessage_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$prepareMessage_u24lambda_u242.add("\n");
        $this$prepareMessage_u24lambda_u242.add("profiler options: " + info.getAgentOptions());
        $this$prepareMessage_u24lambda_u242.add("communicator: " + info.getCommunicator());
        String reasonsStr = reasons.isEmpty() ? "unknown" : CollectionsKt.joinToString$default((Iterable)reasons, null, null, null, (int)0, null, LogErrorAsyncProfilerErrorReporter::prepareMessage$lambda$2$lambda$1, (int)31, null);
        $this$prepareMessage_u24lambda_u242.add("possible reasons: " + reasonsStr);
        if (!StringsKt.isBlank((CharSequence)info.getAdditionalOutput())) {
            $this$prepareMessage_u24lambda_u242.add("additional output:");
            $this$prepareMessage_u24lambda_u242.add(this.logProcessor.invoke((Object)info.getAdditionalOutput()));
        }
        List details = CollectionsKt.build((List)list);
        return TuplesKt.to((Object)mainLine, (Object)UtilKt.toArray((Collection)details, (Object[])new String[0]));
    }

    private final Attachment[] prepareAttachments(String log) {
        if (StringsKt.isBlank((CharSequence)log)) {
            return new Attachment[0];
        }
        Attachment[] attachmentArray = new Attachment[]{new Attachment("agentLog.txt", (String)this.logProcessor.invoke((Object)log))};
        return attachmentArray;
    }

    private static final CharSequence prepareMessage$lambda$2$lambda$1(AsyncProfilerErrorReason it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getShortName();
    }

    private static final String defaultLogProcessor$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/ultimate/async/troubleshooting/report/LogErrorAsyncProfilerErrorReporter$Companion;", "", "<init>", "()V", "defaultLogProcessor", "Lkotlin/Function1;", "", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DumpState.values().length];
            try {
                nArray[DumpState.NOT_EXIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DumpState.EMPTY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DumpState.NON_EMPTY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

