/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.javac.JavacFileReferencesRegistrar;
import org.jetbrains.jps.javac.ast.api.JavacDef;
import org.jetbrains.jps.javac.ast.api.JavacRef;
import org.jetbrains.jps.javac.ast.api.JavacTypeCast;

public final class JpsReferenceDependenciesRegistrar
implements JavacFileReferencesRegistrar {
    @Override
    public void initialize() {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void registerFile(CompileContext context, String filePath, Iterable<Map.Entry<? extends JavacRef, Integer>> refs, Collection<? extends JavacDef> defs, Collection<? extends JavacTypeCast> casts, Collection<? extends JavacRef> implicitToString) {
        HashSet<String> definedClasses = new HashSet<String>();
        for (JavacDef javacDef : defs) {
            JavacRef element;
            if (!(javacDef instanceof JavacDef.JavacClassDef) || !((element = javacDef.getDefinedElement()) instanceof JavacRef.JavacClass)) continue;
            definedClasses.add(element.getName());
        }
        if (definedClasses.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<? extends JavacRef, Integer>> iterator = refs.iterator();
        if (iterator.hasNext()) {
            Callbacks.Backend reg;
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> staticImports = new HashSet<String>();
            HashMap<String, ArrayList<Callbacks.ConstantRef>> cRefs = new HashMap<String, ArrayList<Callbacks.ConstantRef>>();
            while (iterator.hasNext()) {
                JavacRef.JavacField fieldRef;
                String descriptor;
                JavacRef ref = iterator.next().getKey();
                JavacRef.ImportProperties importProps = ref.getImportProperties();
                if (importProps != null) {
                    if (ref instanceof JavacRef.JavacClass) {
                        hashSet.add(ref.getName());
                        if (!importProps.isStatic() || !importProps.isOnDemand()) continue;
                        staticImports.add(ref.getName() + ".*");
                        continue;
                    }
                    if (!(ref instanceof JavacRef.JavacField) && !(ref instanceof JavacRef.JavacMethod)) continue;
                    staticImports.add(ref.getOwnerName() + "." + ref.getName());
                    continue;
                }
                if (!(ref instanceof JavacRef.JavacField) || !ref.getModifiers().contains((Object)Modifier.FINAL) || (descriptor = (fieldRef = (JavacRef.JavacField)ref).getDescriptor()) == null || !definedClasses.contains(fieldRef.getContainingClass()) || definedClasses.contains(fieldRef.getOwnerName())) continue;
                ArrayList<Callbacks.ConstantRef> refsList = (ArrayList<Callbacks.ConstantRef>)cRefs.get(fieldRef.getContainingClass());
                if (refsList == null) {
                    refsList = new ArrayList<Callbacks.ConstantRef>();
                    cRefs.put(fieldRef.getContainingClass(), refsList);
                }
                refsList.add(Callbacks.createConstantReference(fieldRef.getOwnerName(), fieldRef.getName(), descriptor));
            }
            if (!hashSet.isEmpty() || !staticImports.isEmpty()) {
                reg = JavaBuilderUtil.getDependenciesRegistrar(context);
                for (String aClass : definedClasses) {
                    reg.registerImports(aClass, hashSet, staticImports);
                }
            }
            if (!cRefs.isEmpty()) {
                reg = JavaBuilderUtil.getDependenciesRegistrar(context);
                Iterator iterator2 = definedClasses.iterator();
                while (iterator2.hasNext()) {
                    String aClass;
                    List<Callbacks.ConstantRef> classCRefs = (List<Callbacks.ConstantRef>)cRefs.get(aClass = (String)iterator2.next());
                    reg.registerConstantReferences(aClass, classCRefs != null ? classCRefs : Collections.emptyList());
                }
            }
        }
    }
}

