/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.render.svg;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.LineType;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgShape;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimShape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/StrokeDashArraySupport;", "", "()V", "apply", "", "element", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgShape;", "strokeWidth", "", "lineType", "Lorg/jetbrains/letsPlot/core/plot/base/render/linetype/LineType;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/slim/SvgSlimShape;", "toStrokeDashArray", "", "plot-base"})
@SourceDebugExtension(value={"SMAP\nStrokeDashArraySupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StrokeDashArraySupport.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/StrokeDashArraySupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1855#2,2:50\n*S KotlinDebug\n*F\n+ 1 StrokeDashArraySupport.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/StrokeDashArraySupport\n*L\n39#1:50,2\n*E\n"})
public final class StrokeDashArraySupport {
    @NotNull
    public static final StrokeDashArraySupport INSTANCE = new StrokeDashArraySupport();

    private StrokeDashArraySupport() {
    }

    public final void apply(@NotNull SvgShape element, double strokeWidth, @NotNull LineType lineType2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)lineType2, (String)"lineType");
        String dashArray = this.toStrokeDashArray(strokeWidth, lineType2);
        if (dashArray != null) {
            element.strokeDashArray().set(dashArray);
            element.strokeDashOffset().set(lineType2.getDashOffset() * strokeWidth);
        }
    }

    public final void apply(@NotNull SvgSlimShape element, double strokeWidth, @NotNull LineType lineType2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)lineType2, (String)"lineType");
        String dashArray = this.toStrokeDashArray(strokeWidth, lineType2);
        if (dashArray != null) {
            element.setStrokeDashArray(dashArray);
            element.strokeDashOffset(lineType2.getDashOffset() * strokeWidth);
        }
    }

    private final String toStrokeDashArray(double strokeWidth, LineType lineType2) {
        if (lineType2.isSolid()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEach$iv = lineType2.getDashArray();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            double relativeLength = ((Number)element$iv).doubleValue();
            boolean bl = false;
            double length = relativeLength * strokeWidth;
            if (((CharSequence)sb).length() > 0) {
                sb.append(',');
            }
            sb.append(String.valueOf(length));
        }
        return sb.toString();
    }
}

