/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.DependentSpacingRule;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilderKt;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilderUtil;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0005&'()*B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0013J#\u0010\u0016\u001a\u00020\u00172\u001b\u0010\u0018\u001a\u0017\u0012\b\u0012\u00060\u001aR\u00020\u0000\u0012\u0004\u0012\u00020\u00170\u0019\u00a2\u0006\u0002\b\u001bJ#\u0010\u001c\u001a\u00020\u00172\u001b\u0010\u0018\u001a\u0017\u0012\b\u0012\u00060\u001dR\u00020\u0000\u0012\u0004\u0012\u00020\u00170\u0019\u00a2\u0006\u0002\b\u001bJ6\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020 2\b\b\u0002\u0010\"\u001a\u00020 2\b\b\u0002\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;", "", "commonCodeStyleSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "spacingBuilderUtil", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilderUtil;", "<init>", "(Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilderUtil;)V", "getCommonCodeStyleSettings", "()Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "getSpacingBuilderUtil", "()Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilderUtil;", "builders", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Builder;", "Lkotlin/collections/ArrayList;", "getSpacing", "Lcom/intellij/formatting/Spacing;", "parent", "Lcom/intellij/formatting/Block;", "child1", "child2", "simple", "", "init", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$BasicSpacingBuilder;", "Lkotlin/ExtensionFunctionType;", "custom", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$CustomSpacingBuilder;", "createSpacing", "minSpaces", "", "maxSpaces", "minLineFeeds", "keepLineBreaks", "", "keepBlankLines", "Builder", "BasicSpacingBuilder", "Condition", "Rule", "CustomSpacingBuilder", "kotlin.formatter.minimal"})
public final class KotlinSpacingBuilder {
    @NotNull
    private final CommonCodeStyleSettings commonCodeStyleSettings;
    @NotNull
    private final KotlinSpacingBuilderUtil spacingBuilderUtil;
    @NotNull
    private final ArrayList<Builder> builders;

    public KotlinSpacingBuilder(@NotNull CommonCodeStyleSettings commonCodeStyleSettings, @NotNull KotlinSpacingBuilderUtil spacingBuilderUtil) {
        Intrinsics.checkNotNullParameter((Object)commonCodeStyleSettings, (String)"commonCodeStyleSettings");
        Intrinsics.checkNotNullParameter((Object)spacingBuilderUtil, (String)"spacingBuilderUtil");
        this.commonCodeStyleSettings = commonCodeStyleSettings;
        this.spacingBuilderUtil = spacingBuilderUtil;
        this.builders = new ArrayList();
    }

    @NotNull
    public final CommonCodeStyleSettings getCommonCodeStyleSettings() {
        return this.commonCodeStyleSettings;
    }

    @NotNull
    public final KotlinSpacingBuilderUtil getSpacingBuilderUtil() {
        return this.spacingBuilderUtil;
    }

    @Nullable
    public final Spacing getSpacing(@NotNull Block parent, @Nullable Block child1, @NotNull Block child2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
        if (!(parent instanceof ASTBlock && child1 instanceof ASTBlock && child2 instanceof ASTBlock)) {
            return null;
        }
        Iterator<Builder> iterator = this.builders.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Builder> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Builder builder;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            Spacing spacing = builder.getSpacing((ASTBlock)parent, (ASTBlock)child1, (ASTBlock)child2);
            if (spacing == null) continue;
            if (Intrinsics.areEqual((Object)FormatterUtilKt.requireNode((ASTBlock)child1).getElementType(), (Object)KtTokens.EOL_COMMENT) && StringsKt.contains$default((CharSequence)spacing.toString(), (CharSequence)"minLineFeeds=0", (boolean)false, (int)2, null)) {
                ASTNode aSTNode;
                boolean isBeforeBlock = Intrinsics.areEqual((Object)FormatterUtilKt.requireNode((ASTBlock)child2).getElementType(), (Object)KtNodeTypes.BLOCK) || Intrinsics.areEqual((Object)((aSTNode = FormatterUtilKt.requireNode((ASTBlock)child2).getFirstChildNode()) != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.BLOCK);
                int keepBlankLines = isBeforeBlock ? 0 : this.commonCodeStyleSettings.KEEP_BLANK_LINES_IN_CODE;
                return KotlinSpacingBuilder.createSpacing$default(this, 0, 0, 1, true, keepBlankLines, 2, null);
            }
            return spacing;
        }
        return null;
    }

    public final void simple(@NotNull Function1<? super BasicSpacingBuilder, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        BasicSpacingBuilder builder = new BasicSpacingBuilder();
        init.invoke((Object)builder);
        this.builders.add(builder);
    }

    public final void custom(@NotNull Function1<? super CustomSpacingBuilder, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        CustomSpacingBuilder builder = new CustomSpacingBuilder();
        init.invoke((Object)builder);
        this.builders.add(builder);
    }

    @NotNull
    public final Spacing createSpacing(int minSpaces, int maxSpaces, int minLineFeeds, boolean keepLineBreaks, int keepBlankLines) {
        Spacing spacing = Spacing.createSpacing((int)minSpaces, (int)maxSpaces, (int)minLineFeeds, (boolean)keepLineBreaks, (int)keepBlankLines);
        Intrinsics.checkNotNullExpressionValue((Object)spacing, (String)"createSpacing(...)");
        return spacing;
    }

    public static /* synthetic */ Spacing createSpacing$default(KotlinSpacingBuilder kotlinSpacingBuilder, int n, int n2, int n3, boolean bl, int n4, int n5, Object object) {
        if ((n5 & 2) != 0) {
            n2 = n;
        }
        if ((n5 & 4) != 0) {
            n3 = 0;
        }
        if ((n5 & 8) != 0) {
            bl = kotlinSpacingBuilder.commonCodeStyleSettings.KEEP_LINE_BREAKS;
        }
        if ((n5 & 0x10) != 0) {
            n4 = kotlinSpacingBuilder.commonCodeStyleSettings.KEEP_BLANK_LINES_IN_CODE;
        }
        return kotlinSpacingBuilder.createSpacing(n, n2, n3, bl, n4);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$BasicSpacingBuilder;", "Lcom/intellij/formatting/SpacingBuilder;", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Builder;", "<init>", "(Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;)V", "getSpacing", "Lcom/intellij/formatting/Spacing;", "parent", "Lcom/intellij/formatting/ASTBlock;", "left", "right", "kotlin.formatter.minimal"})
    public final class BasicSpacingBuilder
    extends SpacingBuilder
    implements Builder {
        public BasicSpacingBuilder() {
            super(KotlinSpacingBuilder.this.getCommonCodeStyleSettings());
        }

        @Override
        @Nullable
        public Spacing getSpacing(@NotNull ASTBlock parent, @NotNull ASTBlock left, @NotNull ASTBlock right) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return super.getSpacing((Block)parent, (Block)left, (Block)right);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Builder;", "", "getSpacing", "Lcom/intellij/formatting/Spacing;", "parent", "Lcom/intellij/formatting/ASTBlock;", "left", "right", "kotlin.formatter.minimal"})
    private static interface Builder {
        @Nullable
        public Spacing getSpacing(@NotNull ASTBlock var1, @NotNull ASTBlock var2, @NotNull ASTBlock var3);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001BO\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\f\u0010\rJ&\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\tH\u00c6\u0003JQ\u0010!\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\"\u001a\u00020\u00032\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Condition;", "Lkotlin/Function3;", "Lcom/intellij/formatting/ASTBlock;", "", "parent", "Lcom/intellij/psi/tree/IElementType;", "left", "right", "parentSet", "Lcom/intellij/psi/tree/TokenSet;", "leftSet", "rightSet", "<init>", "(Lcom/intellij/psi/tree/IElementType;Lcom/intellij/psi/tree/IElementType;Lcom/intellij/psi/tree/IElementType;Lcom/intellij/psi/tree/TokenSet;Lcom/intellij/psi/tree/TokenSet;Lcom/intellij/psi/tree/TokenSet;)V", "getParent", "()Lcom/intellij/psi/tree/IElementType;", "getLeft", "getRight", "getParentSet", "()Lcom/intellij/psi/tree/TokenSet;", "getLeftSet", "getRightSet", "invoke", "p", "l", "r", "(Lcom/intellij/formatting/ASTBlock;Lcom/intellij/formatting/ASTBlock;Lcom/intellij/formatting/ASTBlock;)Ljava/lang/Boolean;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "", "hashCode", "", "toString", "", "kotlin.formatter.minimal"})
    private static final class Condition
    implements Function3<ASTBlock, ASTBlock, ASTBlock, Boolean> {
        @Nullable
        private final IElementType parent;
        @Nullable
        private final IElementType left;
        @Nullable
        private final IElementType right;
        @Nullable
        private final TokenSet parentSet;
        @Nullable
        private final TokenSet leftSet;
        @Nullable
        private final TokenSet rightSet;

        public Condition(@Nullable IElementType parent, @Nullable IElementType left, @Nullable IElementType right, @Nullable TokenSet parentSet, @Nullable TokenSet leftSet, @Nullable TokenSet rightSet) {
            this.parent = parent;
            this.left = left;
            this.right = right;
            this.parentSet = parentSet;
            this.leftSet = leftSet;
            this.rightSet = rightSet;
        }

        public /* synthetic */ Condition(IElementType iElementType, IElementType iElementType2, IElementType iElementType3, TokenSet tokenSet, TokenSet tokenSet2, TokenSet tokenSet3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                iElementType = null;
            }
            if ((n & 2) != 0) {
                iElementType2 = null;
            }
            if ((n & 4) != 0) {
                iElementType3 = null;
            }
            if ((n & 8) != 0) {
                tokenSet = null;
            }
            if ((n & 0x10) != 0) {
                tokenSet2 = null;
            }
            if ((n & 0x20) != 0) {
                tokenSet3 = null;
            }
            this(iElementType, iElementType2, iElementType3, tokenSet, tokenSet2, tokenSet3);
        }

        @Nullable
        public final IElementType getParent() {
            return this.parent;
        }

        @Nullable
        public final IElementType getLeft() {
            return this.left;
        }

        @Nullable
        public final IElementType getRight() {
            return this.right;
        }

        @Nullable
        public final TokenSet getParentSet() {
            return this.parentSet;
        }

        @Nullable
        public final TokenSet getLeftSet() {
            return this.leftSet;
        }

        @Nullable
        public final TokenSet getRightSet() {
            return this.rightSet;
        }

        @NotNull
        public Boolean invoke(@NotNull ASTBlock p, @NotNull ASTBlock l, @NotNull ASTBlock r) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)l, (String)"l");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            return !(this.parent != null && !Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(p).getElementType(), (Object)this.parent) || this.left != null && !Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(l).getElementType(), (Object)this.left) || this.right != null && !Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(r).getElementType(), (Object)this.right) || this.parentSet != null && !this.parentSet.contains(FormatterUtilKt.requireNode(p).getElementType()) || this.leftSet != null && !this.leftSet.contains(FormatterUtilKt.requireNode(l).getElementType()) || this.rightSet != null && !this.rightSet.contains(FormatterUtilKt.requireNode(r).getElementType()));
        }

        @Nullable
        public final IElementType component1() {
            return this.parent;
        }

        @Nullable
        public final IElementType component2() {
            return this.left;
        }

        @Nullable
        public final IElementType component3() {
            return this.right;
        }

        @Nullable
        public final TokenSet component4() {
            return this.parentSet;
        }

        @Nullable
        public final TokenSet component5() {
            return this.leftSet;
        }

        @Nullable
        public final TokenSet component6() {
            return this.rightSet;
        }

        @NotNull
        public final Condition copy(@Nullable IElementType parent, @Nullable IElementType left, @Nullable IElementType right, @Nullable TokenSet parentSet, @Nullable TokenSet leftSet, @Nullable TokenSet rightSet) {
            return new Condition(parent, left, right, parentSet, leftSet, rightSet);
        }

        public static /* synthetic */ Condition copy$default(Condition condition, IElementType iElementType, IElementType iElementType2, IElementType iElementType3, TokenSet tokenSet, TokenSet tokenSet2, TokenSet tokenSet3, int n, Object object) {
            if ((n & 1) != 0) {
                iElementType = condition.parent;
            }
            if ((n & 2) != 0) {
                iElementType2 = condition.left;
            }
            if ((n & 4) != 0) {
                iElementType3 = condition.right;
            }
            if ((n & 8) != 0) {
                tokenSet = condition.parentSet;
            }
            if ((n & 0x10) != 0) {
                tokenSet2 = condition.leftSet;
            }
            if ((n & 0x20) != 0) {
                tokenSet3 = condition.rightSet;
            }
            return condition.copy(iElementType, iElementType2, iElementType3, tokenSet, tokenSet2, tokenSet3);
        }

        @NotNull
        public String toString() {
            return "Condition(parent=" + this.parent + ", left=" + this.left + ", right=" + this.right + ", parentSet=" + this.parentSet + ", leftSet=" + this.leftSet + ", rightSet=" + this.rightSet + ")";
        }

        public int hashCode() {
            int result = this.parent == null ? 0 : this.parent.hashCode();
            result = result * 31 + (this.left == null ? 0 : this.left.hashCode());
            result = result * 31 + (this.right == null ? 0 : this.right.hashCode());
            result = result * 31 + (this.parentSet == null ? 0 : this.parentSet.hashCode());
            result = result * 31 + (this.leftSet == null ? 0 : this.leftSet.hashCode());
            result = result * 31 + (this.rightSet == null ? 0 : this.rightSet.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Condition)) {
                return false;
            }
            Condition condition = (Condition)other;
            if (!Intrinsics.areEqual((Object)this.parent, (Object)condition.parent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.left, (Object)condition.left)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.right, (Object)condition.right)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.parentSet, (Object)condition.parentSet)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.leftSet, (Object)condition.leftSet)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.rightSet, (Object)condition.rightSet);
        }

        public Condition() {
            this(null, null, null, null, null, null, 63, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016JR\u0010\u0010\u001a\u00060\u0000R\u00020\u00112\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0014J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\"\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001a2\b\b\u0002\u0010\u001f\u001a\u00020\u001a2\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010 \u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u000bJU\u0010!\u001a\u00020\u00182M\u0010\"\u001aI\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000b0#J*\u0010&\u001a\u00020\u00182 \u0010'\u001a\u001c\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000b0#H\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\t0\u0005j\b\u0012\u0004\u0012\u00020\t`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$CustomSpacingBuilder;", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Builder;", "<init>", "(Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;)V", "rules", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Rule;", "Lkotlin/collections/ArrayList;", "conditions", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Condition;", "getSpacing", "Lcom/intellij/formatting/Spacing;", "parent", "Lcom/intellij/formatting/ASTBlock;", "left", "right", "inPosition", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;", "Lcom/intellij/psi/tree/IElementType;", "parentSet", "Lcom/intellij/psi/tree/TokenSet;", "leftSet", "rightSet", "lineBreakIfLineBreakInParent", "", "numSpacesOtherwise", "", "allowBlankLines", "", "emptyLinesIfLineBreakInLeft", "emptyLines", "numberOfLineFeedsOtherwise", "spacing", "customRule", "block", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "newRule", "rule", "kotlin.formatter.minimal"})
    @SourceDebugExtension(value={"SMAP\nKotlinSpacingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSpacingBuilder.kt\norg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$CustomSpacingBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n1#2:215\n*E\n"})
    public final class CustomSpacingBuilder
    implements Builder {
        @NotNull
        private final ArrayList<Rule> rules = new ArrayList();
        @NotNull
        private ArrayList<Condition> conditions = new ArrayList();

        @Override
        @Nullable
        public Spacing getSpacing(@NotNull ASTBlock parent, @NotNull ASTBlock left, @NotNull ASTBlock right) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            Iterator<Rule> iterator = this.rules.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<Rule> iterator2 = iterator;
            while (iterator2.hasNext()) {
                Rule rule;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                Spacing spacing = rule.invoke(parent, left, right);
                if (spacing == null) continue;
                return spacing;
            }
            return null;
        }

        @NotNull
        public final CustomSpacingBuilder inPosition(@Nullable IElementType parent, @Nullable IElementType left, @Nullable IElementType right, @Nullable TokenSet parentSet, @Nullable TokenSet leftSet, @Nullable TokenSet rightSet) {
            this.conditions.add(new Condition(parent, left, right, parentSet, leftSet, rightSet));
            return this;
        }

        public static /* synthetic */ CustomSpacingBuilder inPosition$default(CustomSpacingBuilder customSpacingBuilder, IElementType iElementType, IElementType iElementType2, IElementType iElementType3, TokenSet tokenSet, TokenSet tokenSet2, TokenSet tokenSet3, int n, Object object) {
            if ((n & 1) != 0) {
                iElementType = null;
            }
            if ((n & 2) != 0) {
                iElementType2 = null;
            }
            if ((n & 4) != 0) {
                iElementType3 = null;
            }
            if ((n & 8) != 0) {
                tokenSet = null;
            }
            if ((n & 0x10) != 0) {
                tokenSet2 = null;
            }
            if ((n & 0x20) != 0) {
                tokenSet3 = null;
            }
            return customSpacingBuilder.inPosition(iElementType, iElementType2, iElementType3, tokenSet, tokenSet2, tokenSet3);
        }

        public final void lineBreakIfLineBreakInParent(int numSpacesOtherwise, boolean allowBlankLines) {
            this.newRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> CustomSpacingBuilder.lineBreakIfLineBreakInParent$lambda$0(numSpacesOtherwise, KotlinSpacingBuilder.this, allowBlankLines, arg_0, arg_1, arg_2)));
        }

        public static /* synthetic */ void lineBreakIfLineBreakInParent$default(CustomSpacingBuilder customSpacingBuilder, int n, boolean bl, int n2, Object object) {
            if ((n2 & 2) != 0) {
                bl = true;
            }
            customSpacingBuilder.lineBreakIfLineBreakInParent(n, bl);
        }

        public final void emptyLinesIfLineBreakInLeft(int emptyLines, int numberOfLineFeedsOtherwise, int numSpacesOtherwise) {
            this.newRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$lambda$2(emptyLines, KotlinSpacingBuilder.this, numSpacesOtherwise, numberOfLineFeedsOtherwise, arg_0, arg_1, arg_2)));
        }

        public static /* synthetic */ void emptyLinesIfLineBreakInLeft$default(CustomSpacingBuilder customSpacingBuilder, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 2) != 0) {
                n2 = 1;
            }
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            customSpacingBuilder.emptyLinesIfLineBreakInLeft(n, n2, n3);
        }

        public final void spacing(@NotNull Spacing spacing) {
            Intrinsics.checkNotNullParameter((Object)spacing, (String)"spacing");
            this.newRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> CustomSpacingBuilder.spacing$lambda$3(spacing, arg_0, arg_1, arg_2)));
        }

        public final void customRule(@NotNull Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            this.newRule(block);
        }

        private final void newRule(Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing> rule) {
            ArrayList savedConditions = new ArrayList(this.conditions);
            this.rules.add(new Rule(savedConditions, rule));
            this.conditions.clear();
        }

        private static final Spacing lineBreakIfLineBreakInParent$lambda$0(int $numSpacesOtherwise, KotlinSpacingBuilder this$0, boolean $allowBlankLines, ASTBlock p, ASTBlock aSTBlock, ASTBlock aSTBlock2) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
            return Spacing.createDependentLFSpacing((int)$numSpacesOtherwise, (int)$numSpacesOtherwise, (TextRange)p.getTextRange(), (boolean)this$0.getCommonCodeStyleSettings().KEEP_LINE_BREAKS, (int)($allowBlankLines ? this$0.getCommonCodeStyleSettings().KEEP_BLANK_LINES_IN_CODE : 0));
        }

        /*
         * Unable to fully structure code
         */
        private static final Spacing emptyLinesIfLineBreakInLeft$lambda$2(int $emptyLines, KotlinSpacingBuilder this$0, int $numSpacesOtherwise, int $numberOfLineFeedsOtherwise, ASTBlock var4_4, ASTBlock left, ASTBlock var6_6) {
            Intrinsics.checkNotNullParameter((Object)var4_4, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)var6_6, (String)"<unused var>");
            v0 = left.getNode();
            lastChild = v0 != null && (v0 = v0.getPsi()) != null ? v0.getLastChild() : null;
            leftEndsWithComment = lastChild instanceof PsiComment != false && Intrinsics.areEqual((Object)((PsiComment)lastChild).getTokenType(), (Object)KtTokens.EOL_COMMENT) != false;
            dependentSpacingRule = new DependentSpacingRule(DependentSpacingRule.Trigger.HAS_LINE_FEEDS).registerData(DependentSpacingRule.Anchor.MIN_LINE_FEEDS, $emptyLines + 1);
            var11_10 = left.getNode();
            if (var11_10 == null || (var12_11 = KotlinSpacingBuilderKt.startOfDeclaration(var11_10)) == null) ** GOTO lbl-1000
            it = var12_11.getStartOffset();
            $i$a$-let-KotlinSpacingBuilder$CustomSpacingBuilder$emptyLinesIfLineBreakInLeft$1$textRange$1 = false;
            var13_14 = TextRange.create((int)it, (int)left.getTextRange().getEndOffset());
            if (var13_14 != null) {
                v1 = var13_14;
            } else lbl-1000:
            // 2 sources

            {
                v2 = left.getTextRange();
                v1 = v2;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getTextRange(...)");
            }
            textRange = v1;
            v3 = this$0.getSpacingBuilderUtil();
            v4 = leftEndsWithComment != false ? Math.max(1, $numberOfLineFeedsOtherwise) : $numberOfLineFeedsOtherwise;
            v5 = this$0.getCommonCodeStyleSettings().KEEP_LINE_BREAKS;
            v6 = this$0.getCommonCodeStyleSettings().KEEP_BLANK_LINES_IN_DECLARATIONS;
            Intrinsics.checkNotNull((Object)dependentSpacingRule);
            return v3.createLineFeedDependentSpacing($numSpacesOtherwise, $numSpacesOtherwise, v4, v5, v6, textRange, dependentSpacingRule);
        }

        private static final Spacing spacing$lambda$3(Spacing $spacing, ASTBlock aSTBlock, ASTBlock aSTBlock2, ASTBlock aSTBlock3) {
            Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)aSTBlock3, (String)"<unused var>");
            return $spacing;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B7\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012 \u0010\u0007\u001a\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002H\u0096\u0002J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0013\u001a\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001H\u00c6\u0003J=\u0010\u0014\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\"\b\u0002\u0010\u0007\u001a\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR+\u0010\u0007\u001a\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Rule;", "Lkotlin/Function3;", "Lcom/intellij/formatting/ASTBlock;", "Lcom/intellij/formatting/Spacing;", "conditions", "", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Condition;", "action", "<init>", "(Ljava/util/List;Lkotlin/jvm/functions/Function3;)V", "getConditions", "()Ljava/util/List;", "getAction", "()Lkotlin/jvm/functions/Function3;", "invoke", "p", "l", "r", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin.formatter.minimal"})
    @SourceDebugExtension(value={"SMAP\nKotlinSpacingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSpacingBuilder.kt\norg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Rule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n1740#2,3:215\n*S KotlinDebug\n*F\n+ 1 KotlinSpacingBuilder.kt\norg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Rule\n*L\n65#1:215,3\n*E\n"})
    private static final class Rule
    implements Function3<ASTBlock, ASTBlock, ASTBlock, Spacing> {
        @NotNull
        private final List<Condition> conditions;
        @NotNull
        private final Function3<ASTBlock, ASTBlock, ASTBlock, Spacing> action;

        public Rule(@NotNull List<Condition> conditions, @NotNull Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing> action) {
            Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.conditions = conditions;
            this.action = action;
        }

        @NotNull
        public final List<Condition> getConditions() {
            return this.conditions;
        }

        @NotNull
        public final Function3<ASTBlock, ASTBlock, ASTBlock, Spacing> getAction() {
            return this.action;
        }

        @Nullable
        public Spacing invoke(@NotNull ASTBlock p, @NotNull ASTBlock l, @NotNull ASTBlock r) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Intrinsics.checkNotNullParameter((Object)l, (String)"l");
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                Iterable $this$all$iv = this.conditions;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Condition it = (Condition)element$iv;
                        boolean bl2 = false;
                        if (it.invoke(p, l, r).booleanValue()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl ? (Spacing)this.action.invoke((Object)p, (Object)l, (Object)r) : null;
        }

        @NotNull
        public final List<Condition> component1() {
            return this.conditions;
        }

        @NotNull
        public final Function3<ASTBlock, ASTBlock, ASTBlock, Spacing> component2() {
            return this.action;
        }

        @NotNull
        public final Rule copy(@NotNull List<Condition> conditions, @NotNull Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing> action) {
            Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            return new Rule(conditions, action);
        }

        public static /* synthetic */ Rule copy$default(Rule rule, List list, Function3 function3, int n, Object object) {
            if ((n & 1) != 0) {
                list = rule.conditions;
            }
            if ((n & 2) != 0) {
                function3 = rule.action;
            }
            return rule.copy(list, function3);
        }

        @NotNull
        public String toString() {
            return "Rule(conditions=" + this.conditions + ", action=" + this.action + ")";
        }

        public int hashCode() {
            int result = ((Object)this.conditions).hashCode();
            result = result * 31 + this.action.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Rule)) {
                return false;
            }
            Rule rule = (Rule)other;
            if (!Intrinsics.areEqual(this.conditions, rule.conditions)) {
                return false;
            }
            return Intrinsics.areEqual(this.action, rule.action);
        }
    }
}

