/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.ui.editor;

import com.intellij.notebooks.ui.NotebookPluginDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/notebooks/ui/editor/NotebookEditorAppearanceManager;", "", "<init>", "()V", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/editor/colors/EditorColorsListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addEditorColorsListener", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listener", "intellij.notebooks.ui"})
public final class NotebookEditorAppearanceManager {
    @NotNull
    private final MessageBusConnection connection;
    @NotNull
    private final EventDispatcher<EditorColorsListener> eventDispatcher;

    public NotebookEditorAppearanceManager() {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        NotebookPluginDisposable notebookPluginDisposable = NotebookPluginDisposable.Companion.getInstance();
        Intrinsics.checkNotNull((Object)notebookPluginDisposable, (String)"null cannot be cast to non-null type com.intellij.openapi.Disposable");
        this.connection = messageBus.connect((Disposable)notebookPluginDisposable);
        EventDispatcher eventDispatcher = EventDispatcher.create(EditorColorsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        this.connection.subscribe(topic, arg_0 -> NotebookEditorAppearanceManager._init_$lambda$0(this, arg_0));
    }

    public final void addEditorColorsListener(@NotNull Disposable parentDisposable, @NotNull EditorColorsListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.eventDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    private static final void _init_$lambda$0(NotebookEditorAppearanceManager this$0, EditorColorsScheme scheme) {
        ((EditorColorsListener)this$0.eventDispatcher.getMulticaster()).globalSchemeChange(scheme);
    }
}

