/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.fgap;

import jakarta.ws.rs.ForbiddenException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.AuthorizationProviderFactory;
import org.keycloak.authorization.common.DefaultEvaluationContext;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.identity.UserModelIdentity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.common.Profile;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.fgap.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.fgap.AdminPermissionManagement;
import org.keycloak.services.resources.admin.fgap.ClientPermissions;
import org.keycloak.services.resources.admin.fgap.GroupPermissions;
import org.keycloak.services.resources.admin.fgap.IdentityProviderPermissions;
import org.keycloak.services.resources.admin.fgap.RealmPermissions;
import org.keycloak.services.resources.admin.fgap.RealmsPermissionEvaluator;
import org.keycloak.services.resources.admin.fgap.RolePermissions;
import org.keycloak.services.resources.admin.fgap.UserPermissions;

class MgmtPermissions
implements AdminPermissionEvaluator,
AdminPermissionManagement,
RealmsPermissionEvaluator {
    protected RealmModel realm;
    protected KeycloakSession session;
    protected AuthorizationProvider authz;
    protected AdminAuth auth;
    protected Identity identity;
    protected UserModel admin;
    protected RealmModel adminsRealm;
    protected ResourceServer realmResourceServer;
    protected UserPermissions users;
    protected GroupPermissions groups;
    protected RealmPermissions realmPermissions;
    protected ClientPermissions clientPermissions;
    protected IdentityProviderPermissions idpPermissions;
    protected RolePermissions rolePermissions;
    protected Scope manageScope;
    protected Scope viewScope;

    MgmtPermissions(KeycloakSession session, RealmModel realm) {
        this.session = session;
        this.realm = realm;
        KeycloakSessionFactory keycloakSessionFactory = session.getKeycloakSessionFactory();
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ) || Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ_V2)) {
            AuthorizationProviderFactory factory = (AuthorizationProviderFactory)keycloakSessionFactory.getProviderFactory(AuthorizationProvider.class);
            this.authz = factory.create(session, realm);
        }
    }

    MgmtPermissions(KeycloakSession session, RealmModel realm, AdminAuth auth) {
        this(session, realm);
        this.auth = auth;
        this.admin = auth.getUser();
        this.adminsRealm = auth.getRealm();
        if (!auth.getRealm().equals(realm) && !RealmManager.isAdministrationRealm(auth.getRealm())) {
            throw new ForbiddenException();
        }
        this.initIdentity(session, auth);
    }

    MgmtPermissions(KeycloakSession session, AdminAuth auth) {
        this.session = session;
        this.auth = auth;
        this.admin = auth.getUser();
        this.adminsRealm = auth.getRealm();
        this.initIdentity(session, auth);
    }

    private void initIdentity(KeycloakSession session, AdminAuth auth) {
        AccessToken accessToken = auth.getToken();
        AuthenticationManager.resolveLightweightAccessTokenRoles(session, accessToken, this.adminsRealm);
        this.identity = new KeycloakIdentity(accessToken, session, this.adminsRealm);
    }

    MgmtPermissions(KeycloakSession session, RealmModel adminsRealm, UserModel admin) {
        this.session = session;
        this.admin = admin;
        this.adminsRealm = adminsRealm;
        this.identity = new UserModelIdentity(adminsRealm, admin);
    }

    MgmtPermissions(KeycloakSession session, RealmModel realm, RealmModel adminsRealm, UserModel admin) {
        this(session, realm);
        this.admin = admin;
        this.adminsRealm = adminsRealm;
        this.identity = new UserModelIdentity(realm, admin);
    }

    @Override
    public ClientModel getRealmPermissionsClient() {
        if (this.realm.getName().equals(Config.getAdminRealm())) {
            return this.realm.getClientByClientId(Config.getAdminRealm() + "-realm");
        }
        return this.realm.getClientByClientId("realm-management");
    }

    @Override
    public AuthorizationProvider authz() {
        return this.authz;
    }

    @Override
    public void requireAnyAdminRole() {
        if (!this.hasAnyAdminRole()) {
            throw new ForbiddenException();
        }
    }

    public boolean hasAnyAdminRole() {
        return this.hasOneAdminRole(AdminRoles.ALL_REALM_ROLES);
    }

    public boolean hasAnyAdminRole(RealmModel realm) {
        return this.hasOneAdminRole(realm, AdminRoles.ALL_REALM_ROLES);
    }

    @Override
    public boolean hasOneAdminRole(String ... adminRoles) {
        return this.hasOneAdminRole(this.realm, adminRoles);
    }

    public boolean hasOneAdminRole(RealmModel realm, String ... adminRoles) {
        String clientId;
        RealmManager realmManager = new RealmManager(this.session);
        if (RealmManager.isAdministrationRealm(this.adminsRealm)) {
            clientId = realm.getMasterAdminClient().getClientId();
        } else if (this.adminsRealm.equals(realm)) {
            clientId = realm.getClientByClientId(realmManager.getRealmAdminClientId(realm)).getClientId();
        } else {
            return false;
        }
        return this.identity.hasOneClientRole(clientId, adminRoles);
    }

    public boolean isAdminSameRealm() {
        return this.auth == null || this.realm.getId().equals(this.auth.getRealm().getId());
    }

    @Override
    public AdminAuth adminAuth() {
        return this.auth;
    }

    public Identity identity() {
        return this.identity;
    }

    public UserModel admin() {
        return this.admin;
    }

    public RealmModel adminsRealm() {
        return this.adminsRealm;
    }

    @Override
    public RolePermissions roles() {
        if (this.rolePermissions != null) {
            return this.rolePermissions;
        }
        this.rolePermissions = new RolePermissions(this.session, this.realm, this.authz, this);
        return this.rolePermissions;
    }

    @Override
    public UserPermissions users() {
        if (this.users != null) {
            return this.users;
        }
        this.users = new UserPermissions(this.session, this.authz, this);
        return this.users;
    }

    @Override
    public RealmPermissions realm() {
        if (this.realmPermissions != null) {
            return this.realmPermissions;
        }
        this.realmPermissions = new RealmPermissions(this);
        return this.realmPermissions;
    }

    @Override
    public ClientPermissions clients() {
        if (this.clientPermissions != null) {
            return this.clientPermissions;
        }
        this.clientPermissions = new ClientPermissions(this.session, this.realm, this.authz, this);
        return this.clientPermissions;
    }

    @Override
    public IdentityProviderPermissions idps() {
        if (this.idpPermissions != null) {
            return this.idpPermissions;
        }
        this.idpPermissions = new IdentityProviderPermissions(this.session, this.realm, this.authz, this);
        return this.idpPermissions;
    }

    @Override
    public GroupPermissions groups() {
        if (this.groups != null) {
            return this.groups;
        }
        this.groups = new GroupPermissions(this.authz, this);
        return this.groups;
    }

    public ResourceServer findOrCreateResourceServer(ClientModel client) {
        return this.initializeRealmResourceServer();
    }

    public ResourceServer resourceServer(ClientModel client) {
        return this.realmResourceServer();
    }

    @Override
    public ResourceServer realmResourceServer() {
        if (this.authz == null) {
            return null;
        }
        if (this.realmResourceServer != null) {
            return this.realmResourceServer;
        }
        ClientModel client = this.getRealmPermissionsClient();
        if (client == null) {
            return null;
        }
        this.realmResourceServer = this.authz.getStoreFactory().getResourceServerStore().findByClient(client);
        return this.realmResourceServer;
    }

    public ResourceServer initializeRealmResourceServer() {
        if (this.authz == null) {
            return null;
        }
        if (this.realmResourceServer != null) {
            return this.realmResourceServer;
        }
        ClientModel client = this.getRealmPermissionsClient();
        if (client == null) {
            return null;
        }
        this.realmResourceServer = this.authz.getStoreFactory().getResourceServerStore().findByClient(client);
        if (this.realmResourceServer == null) {
            this.realmResourceServer = this.authz.getStoreFactory().getResourceServerStore().create(client);
        }
        return this.realmResourceServer;
    }

    public void initializeRealmDefaultScopes() {
        ResourceServer server = this.initializeRealmResourceServer();
        if (server == null) {
            return;
        }
        this.manageScope = this.initializeRealmScope("manage");
        this.viewScope = this.initializeRealmScope("view");
    }

    public Scope initializeRealmScope(String name) {
        ResourceServer server = this.initializeRealmResourceServer();
        if (server == null) {
            return null;
        }
        Scope scope = this.authz.getStoreFactory().getScopeStore().findByName(server, name);
        if (scope == null) {
            scope = this.authz.getStoreFactory().getScopeStore().create(server, name);
        }
        return scope;
    }

    public Scope initializeScope(String name, ResourceServer server) {
        if (this.authz == null) {
            return null;
        }
        Scope scope = this.authz.getStoreFactory().getScopeStore().findByName(server, name);
        if (scope == null) {
            scope = this.authz.getStoreFactory().getScopeStore().create(server, name);
        }
        return scope;
    }

    public Scope realmManageScope() {
        if (this.manageScope != null) {
            return this.manageScope;
        }
        this.manageScope = this.realmScope("manage");
        return this.manageScope;
    }

    public Scope realmViewScope() {
        if (this.viewScope != null) {
            return this.viewScope;
        }
        this.viewScope = this.realmScope("view");
        return this.viewScope;
    }

    public Scope realmScope(String scope) {
        ResourceServer server = this.realmResourceServer();
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getScopeStore().findByName(server, scope);
    }

    public boolean evaluatePermission(Resource resource, ResourceServer resourceServer, Scope ... scope) {
        Identity identity = this.identity();
        if (identity == null) {
            throw new RuntimeException("Identity of admin is not set for permission query");
        }
        return this.evaluatePermission(resource, resourceServer, identity, scope);
    }

    public Collection<Permission> evaluatePermission(ResourcePermission permission, ResourceServer resourceServer) {
        return this.evaluatePermission(permission, resourceServer, (EvaluationContext)new DefaultEvaluationContext(this.identity, this.session));
    }

    public Collection<Permission> evaluatePermission(List<ResourcePermission> permission, ResourceServer resourceServer) {
        return this.evaluatePermission(permission, resourceServer, (EvaluationContext)new DefaultEvaluationContext(this.identity, this.session));
    }

    public Collection<Permission> evaluatePermission(ResourcePermission permission, ResourceServer resourceServer, EvaluationContext context) {
        return this.evaluatePermission(Arrays.asList(permission), resourceServer, context);
    }

    public boolean evaluatePermission(Resource resource, ResourceServer resourceServer, Identity identity, Scope ... scope) {
        DefaultEvaluationContext context = new DefaultEvaluationContext(identity, this.session);
        return this.evaluatePermission(resource, resourceServer, context, scope);
    }

    public boolean evaluatePermission(Resource resource, ResourceServer resourceServer, EvaluationContext context, Scope ... scope) {
        return !this.evaluatePermission(Arrays.asList(new ResourcePermission(resource, Arrays.asList(scope), resourceServer)), resourceServer, context).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Permission> evaluatePermission(List<ResourcePermission> permissions, ResourceServer resourceServer, EvaluationContext context) {
        RealmModel oldRealm = this.session.getContext().getRealm();
        try {
            this.session.getContext().setRealm(this.realm);
            Collection collection = this.authz.evaluators().from(permissions, resourceServer, context).evaluate(resourceServer, null);
            return collection;
        }
        finally {
            this.session.getContext().setRealm(oldRealm);
        }
    }

    @Override
    public boolean canView(RealmModel realm) {
        return this.hasOneAdminRole(realm, "view-realm", "manage-realm");
    }

    @Override
    public boolean isAdmin(RealmModel realm) {
        return this.hasAnyAdminRole(realm);
    }

    @Override
    public boolean isAdmin() {
        if (RealmManager.isAdministrationRealm(this.adminsRealm)) {
            if (this.identity.hasRealmRole("admin") || this.identity.hasRealmRole("create-realm")) {
                return true;
            }
            return this.session.realms().getRealmsStream().anyMatch(this::isAdmin);
        }
        return this.isAdmin(this.adminsRealm);
    }

    @Override
    public boolean canCreateRealm() {
        if (!RealmManager.isAdministrationRealm(this.auth.getRealm())) {
            return false;
        }
        return this.identity.hasRealmRole("create-realm");
    }

    @Override
    public void requireCreateRealm() {
        if (!this.canCreateRealm()) {
            throw new ForbiddenException();
        }
    }
}

