/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.serializer.methods;

import java.awt.BasicStroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.pentaho.reporting.libraries.serializer.SerializeMethod;

public class BasicStrokeSerializer
implements SerializeMethod {
    @Override
    public void writeObject(Object o, ObjectOutputStream stream) throws IOException {
        BasicStroke s = (BasicStroke)o;
        stream.writeFloat(s.getLineWidth());
        stream.writeInt(s.getEndCap());
        stream.writeInt(s.getLineJoin());
        stream.writeFloat(s.getMiterLimit());
        stream.writeObject(s.getDashArray());
        stream.writeFloat(s.getDashPhase());
    }

    @Override
    public Object readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        float width = stream.readFloat();
        int cap = stream.readInt();
        int join = stream.readInt();
        float miterLimit = stream.readFloat();
        float[] dash = (float[])stream.readObject();
        float dashPhase = stream.readFloat();
        return new BasicStroke(width, cap, join, miterLimit, dash, dashPhase);
    }

    @Override
    public Class getObjectClass() {
        return BasicStroke.class;
    }
}

