/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * abs(-5) => 5
 * abs(-2) => 2
 * abs(-1) => 1
 * abs(0) => 0
 * abs(1) => 1
 * abs(2) => 2
 * abs(5) => 5
 */
#version 130

void main()
{
  float[abs(-5) == 5 ? 1 : -1] array0;
  float[abs(-2) == 2 ? 1 : -1] array1;
  float[abs(-1) == 1 ? 1 : -1] array2;
  float[abs(0) == 0 ? 1 : -1] array3;
  float[abs(1) == 1 ? 1 : -1] array4;
  float[abs(2) == 2 ? 1 : -1] array5;
  float[abs(5) == 5 ? 1 : -1] array6;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length());
}
