/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class JRClassGenerator {
    private static final int EXPR_MAX_COUNT_PER_METHOD = 100;
    private JasperDesign jasperDesign = null;
    private static Map fieldPrefixMap = null;
    private static Map variablePrefixMap = null;
    private static Map methodSuffixMap = null;

    protected JRClassGenerator(JasperDesign jrDesign) {
        this.jasperDesign = jrDesign;
        fieldPrefixMap = new HashMap();
        fieldPrefixMap.put(new Byte(1), "Old");
        fieldPrefixMap.put(new Byte(2), "");
        fieldPrefixMap.put(new Byte(3), "");
        variablePrefixMap = new HashMap();
        variablePrefixMap.put(new Byte(1), "Old");
        variablePrefixMap.put(new Byte(2), "Estimated");
        variablePrefixMap.put(new Byte(3), "");
        methodSuffixMap = new HashMap();
        methodSuffixMap.put(new Byte(1), "Old");
        methodSuffixMap.put(new Byte(2), "Estimated");
        methodSuffixMap.put(new Byte(3), "");
    }

    public static String generateClass(JasperDesign jrDesign) throws JRException {
        JRClassGenerator generator = new JRClassGenerator(jrDesign);
        return generator.generateClass();
    }

    protected String generateClass() throws JRException {
        StringBuffer sb = new StringBuffer();
        sb.append("/*\n");
        sb.append(" * Generated by JasperReports - ");
        sb.append(new SimpleDateFormat().format(new Date()));
        sb.append("\n");
        sb.append(" */\n");
        sb.append("import net.sf.jasperreports.engine.*;\n");
        sb.append("import net.sf.jasperreports.engine.fill.*;\n");
        sb.append("\n");
        sb.append("import java.util.*;\n");
        sb.append("import java.math.*;\n");
        sb.append("import java.text.*;\n");
        sb.append("import java.io.*;\n");
        sb.append("import java.net.*;\n");
        sb.append("\n");
        String[] imports = this.jasperDesign.getImports();
        if (imports != null && imports.length > 0) {
            for (int i = 0; i < imports.length; ++i) {
                sb.append("import ");
                sb.append(imports[i]);
                sb.append(";\n");
            }
        }
        sb.append("\n");
        sb.append("\n");
        sb.append("/**\n");
        sb.append(" *\n");
        sb.append(" */\n");
        sb.append("public class ");
        sb.append(this.jasperDesign.getName());
        sb.append(" extends JRCalculator\n");
        sb.append("{\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        Map parametersMap = this.jasperDesign.getParametersMap();
        if (parametersMap != null && parametersMap.size() > 0) {
            Set parameterNames = parametersMap.keySet();
            Iterator it = parameterNames.iterator();
            while (it.hasNext()) {
                sb.append("    private JRFillParameter parameter_");
                sb.append(JRStringUtil.getLiteral((String)it.next()));
                sb.append(" = null;\n");
            }
        }
        sb.append("\n");
        Map fieldsMap = this.jasperDesign.getFieldsMap();
        if (fieldsMap != null && fieldsMap.size() > 0) {
            Set fieldNames = fieldsMap.keySet();
            Iterator it = fieldNames.iterator();
            while (it.hasNext()) {
                sb.append("    private JRFillField field_");
                sb.append(JRStringUtil.getLiteral((String)it.next()));
                sb.append(" = null;\n");
            }
        }
        sb.append("\n");
        JRVariable[] variables = this.jasperDesign.getVariables();
        if (variables != null && variables.length > 0) {
            for (int i = 0; i < variables.length; ++i) {
                sb.append("    private JRFillVariable variable_");
                sb.append(JRStringUtil.getLiteral(variables[i].getName()));
                sb.append(" = null;\n");
            }
        }
        this.generateInitMethod(sb);
        sb.append(this.generateMethod((byte)3));
        sb.append(this.generateMethod((byte)1));
        sb.append(this.generateMethod((byte)2));
        sb.append("}\n");
        return sb.toString();
    }

    protected void generateInitMethod(StringBuffer sb) throws JRException {
        sb.append("\n");
        sb.append("\n");
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        sb.append("    public void customizedInit(\n");
        sb.append("        Map pm,\n");
        sb.append("        Map fm,\n");
        sb.append("        Map vm\n");
        sb.append("        )\n");
        sb.append("    {\n");
        sb.append("        initParams(pm);\n");
        sb.append("        initFields(fm);\n");
        sb.append("        initVars(vm);\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("\n");
        Map parametersMap = this.jasperDesign.getParametersMap();
        Iterator<Object> parIt = null;
        parIt = parametersMap != null && parametersMap.size() > 0 ? parametersMap.keySet().iterator() : Collections.EMPTY_SET.iterator();
        this.generateInitParamsMethod(sb, parIt, 0);
        Map fieldsMap = this.jasperDesign.getFieldsMap();
        Iterator<Object> fieldIt = null;
        fieldIt = fieldsMap != null && fieldsMap.size() > 0 ? fieldsMap.keySet().iterator() : Collections.EMPTY_SET.iterator();
        this.generateInitFieldsMethod(sb, fieldIt, 0);
        JRVariable[] variables = this.jasperDesign.getVariables();
        Iterator<Object> varIt = null;
        varIt = variables != null && variables.length > 0 ? Arrays.asList(variables).iterator() : Collections.EMPTY_LIST.iterator();
        this.generateInitVarsMethod(sb, varIt, 0);
    }

    private void generateInitParamsMethod(StringBuffer sb, Iterator it, int index) throws JRException {
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        sb.append("    private void initParams");
        if (index > 0) {
            sb.append(index);
        }
        sb.append("(Map pm)\n");
        sb.append("    {\n");
        for (int i = 0; i < 100 && it.hasNext(); ++i) {
            String parameterName = (String)it.next();
            sb.append("        parameter_");
            sb.append(JRStringUtil.getLiteral(parameterName));
            sb.append(" = (JRFillParameter)pm.get(\"");
            sb.append(parameterName);
            sb.append("\");\n");
        }
        if (it.hasNext()) {
            sb.append("        initParams");
            sb.append(index + 1);
            sb.append("(pm);\n");
        }
        sb.append("    }\n");
        sb.append("\n");
        sb.append("\n");
        if (it.hasNext()) {
            this.generateInitParamsMethod(sb, it, index + 1);
        }
    }

    private void generateInitFieldsMethod(StringBuffer sb, Iterator it, int index) throws JRException {
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        sb.append("    private void initFields");
        if (index > 0) {
            sb.append(index);
        }
        sb.append("(Map fm)\n");
        sb.append("    {\n");
        for (int i = 0; i < 100 && it.hasNext(); ++i) {
            String fieldName = (String)it.next();
            sb.append("        field_");
            sb.append(JRStringUtil.getLiteral(fieldName));
            sb.append(" = (JRFillField)fm.get(\"");
            sb.append(fieldName);
            sb.append("\");\n");
        }
        if (it.hasNext()) {
            sb.append("        initFields");
            sb.append(index + 1);
            sb.append("(fm);\n");
        }
        sb.append("    }\n");
        sb.append("\n");
        sb.append("\n");
        if (it.hasNext()) {
            this.generateInitFieldsMethod(sb, it, index + 1);
        }
    }

    private void generateInitVarsMethod(StringBuffer sb, Iterator it, int index) throws JRException {
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        sb.append("    private void initVars");
        if (index > 0) {
            sb.append(index);
        }
        sb.append("(Map vm)\n");
        sb.append("    {\n");
        for (int i = 0; i < 100 && it.hasNext(); ++i) {
            String variableName = ((JRVariable)it.next()).getName();
            sb.append("        variable_");
            sb.append(JRStringUtil.getLiteral(variableName));
            sb.append(" = (JRFillVariable)vm.get(\"");
            sb.append(variableName);
            sb.append("\");\n");
        }
        if (it.hasNext()) {
            sb.append("        initVars");
            sb.append(index + 1);
            sb.append("(vm);\n");
        }
        sb.append("    }\n");
        sb.append("\n");
        sb.append("\n");
        if (it.hasNext()) {
            this.generateInitVarsMethod(sb, it, index + 1);
        }
    }

    private String generateMethod(byte evaluationType) throws JRException {
        StringBuffer sb = new StringBuffer();
        Collection expressions = this.jasperDesign.getExpressions();
        if (expressions != null && expressions.size() > 0) {
            sb.append(this.generateMethod(expressions.iterator(), 0, evaluationType));
        } else {
            sb.append("    /**\n");
            sb.append("     *\n");
            sb.append("     */\n");
            sb.append("    public Object evaluate");
            sb.append((String)methodSuffixMap.get(new Byte(evaluationType)));
            sb.append("(int id) throws Throwable\n");
            sb.append("    {\n");
            sb.append("        return null;\n");
            sb.append("    }\n");
            sb.append("\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    private String generateMethod(Iterator it, int index, byte evaluationType) throws JRException {
        StringBuffer sb = new StringBuffer();
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        if (index > 0) {
            sb.append("    private Object evaluate");
            sb.append((String)methodSuffixMap.get(new Byte(evaluationType)));
            sb.append(index);
        } else {
            sb.append("    public Object evaluate");
            sb.append((String)methodSuffixMap.get(new Byte(evaluationType)));
        }
        sb.append("(int id) throws Throwable\n");
        sb.append("    {\n");
        sb.append("        Object value = null;\n");
        sb.append("\n");
        sb.append("        switch (id)\n");
        sb.append("        {\n");
        JRExpression expression = null;
        for (int i = 0; it.hasNext() && i < 100; ++i) {
            expression = (JRExpression)it.next();
            sb.append("            case ");
            sb.append(expression.getId());
            sb.append(" : // ");
            sb.append(expression.getId());
            sb.append("\n");
            sb.append("            {\n");
            sb.append("                value = (");
            sb.append(expression.getValueClassName());
            sb.append(")(");
            sb.append(this.generateExpression(expression, evaluationType));
            sb.append(");\n");
            sb.append("                break;\n");
            sb.append("            }\n");
        }
        sb.append("           default :\n");
        sb.append("           {\n");
        if (it.hasNext()) {
            sb.append("               value = evaluate");
            sb.append((String)methodSuffixMap.get(new Byte(evaluationType)));
            sb.append(index + 1);
            sb.append("(id);\n");
        }
        sb.append("           }\n");
        sb.append("        }\n");
        sb.append("        \n");
        sb.append("        return value;\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("\n");
        if (it.hasNext()) {
            sb.append(this.generateMethod(it, index + 1, evaluationType));
        }
        return sb.toString();
    }

    private String generateExpression(JRExpression expression, byte evaluationType) {
        Map parametersMap = this.jasperDesign.getParametersMap();
        Map fieldsMap = this.jasperDesign.getFieldsMap();
        Map variablesMap = this.jasperDesign.getVariablesMap();
        JRParameter jrParameter = null;
        JRField jrField = null;
        JRVariable jrVariable = null;
        StringBuffer sb = new StringBuffer();
        JRExpressionChunk[] chunks = expression.getChunks();
        JRExpressionChunk chunk = null;
        String chunkText = null;
        if (chunks != null && chunks.length > 0) {
            block7: for (int i = 0; i < chunks.length; ++i) {
                chunk = chunks[i];
                chunkText = chunk.getText();
                if (chunkText == null) {
                    chunkText = "";
                }
                switch (chunk.getType()) {
                    case 1: {
                        sb.append(chunkText);
                        continue block7;
                    }
                    case 2: {
                        jrParameter = (JRParameter)parametersMap.get(chunkText);
                        sb.append("((");
                        sb.append(jrParameter.getValueClassName());
                        sb.append(")parameter_");
                        sb.append(JRStringUtil.getLiteral(chunkText));
                        sb.append(".getValue())");
                        continue block7;
                    }
                    case 3: {
                        jrField = (JRField)fieldsMap.get(chunkText);
                        sb.append("((");
                        sb.append(jrField.getValueClassName());
                        sb.append(")field_");
                        sb.append(JRStringUtil.getLiteral(chunkText));
                        sb.append(".get");
                        sb.append((String)fieldPrefixMap.get(new Byte(evaluationType)));
                        sb.append("Value())");
                        continue block7;
                    }
                    case 4: {
                        jrVariable = (JRVariable)variablesMap.get(chunkText);
                        sb.append("((");
                        sb.append(jrVariable.getValueClassName());
                        sb.append(")variable_");
                        sb.append(JRStringUtil.getLiteral(chunkText));
                        sb.append(".get");
                        sb.append((String)variablePrefixMap.get(new Byte(evaluationType)));
                        sb.append("Value())");
                        continue block7;
                    }
                    case 5: {
                        sb.append("str(\"");
                        sb.append(chunkText);
                        sb.append("\")");
                    }
                }
            }
        }
        if (sb.length() == 0) {
            sb.append("null");
        }
        return sb.toString();
    }
}

