/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.util;

import java.awt.Color;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class RelativeColor
implements UIDefaults.LazyValue {
    private Color value = null;
    private Color fallback = null;
    private Color targetColor = null;
    private String targetColorKey = null;
    private Color baseColor = null;
    private String baseColorKey = null;
    private Color mustContrastColor = null;
    private String mustContrastColorKey = null;
    private Color actualColor = null;
    private String actualColorKey = null;

    public RelativeColor(Object object, Object object2, Object object3, Object object4) {
        if (object == null || object2 == null || object3 == null) {
            throw new NullPointerException("Null argument(s): " + object + ',' + object2 + ',' + object3 + ',' + object4);
        }
        if (object instanceof String) {
            this.baseColorKey = (String)object;
        } else {
            this.baseColor = (Color)object;
        }
        if (object2 instanceof String) {
            this.targetColorKey = (String)object2;
        } else {
            this.targetColor = (Color)object2;
        }
        if (object3 instanceof String) {
            this.actualColorKey = (String)object3;
        } else {
            this.actualColor = (Color)object3;
        }
        if (object4 != null) {
            if (object4 instanceof String) {
                this.mustContrastColorKey = (String)object4;
            } else {
                this.mustContrastColor = (Color)object4;
            }
        }
    }

    public RelativeColor(Color color, Color color2, Object object) {
        this(color, color2, object, null);
    }

    public void clear() {
        this.value = null;
        if (this.actualColorKey != null) {
            this.actualColor = null;
        }
        if (this.targetColorKey != null) {
            this.targetColor = null;
        }
        if (this.mustContrastColorKey != null) {
            this.mustContrastColor = null;
        }
        if (this.baseColorKey != null) {
            this.baseColor = null;
        }
    }

    public Object createValue(UIDefaults uIDefaults) {
        Color color;
        if (this.value != null) {
            return this.value;
        }
        Color color2 = this.getActualColor();
        this.value = color2.equals(color = this.getBaseColor()) ? this.getTargetColor() : RelativeColor.deriveColor(color, color2, this.getTargetColor());
        if (this.hasMustContrastColor()) {
            this.value = RelativeColor.ensureContrast(this.value, this.getMustContrastColor());
        }
        return this.value;
    }

    public Color getColor() {
        return (Color)this.createValue(null);
    }

    private Color getTargetColor() {
        if (this.checkState(this.targetColor, this.targetColorKey)) {
            this.targetColor = this.fetchColor(this.targetColorKey);
        }
        return this.targetColor;
    }

    private Color getBaseColor() {
        if (this.checkState(this.baseColor, this.baseColorKey)) {
            this.baseColor = this.fetchColor(this.baseColorKey);
        }
        return this.baseColor;
    }

    private Color getMustContrastColor() {
        if (this.checkState(this.mustContrastColor, this.mustContrastColorKey)) {
            this.mustContrastColor = this.fetchColor(this.mustContrastColorKey);
        }
        return this.mustContrastColor;
    }

    private Color getActualColor() {
        if (this.checkState(this.actualColor, this.actualColorKey)) {
            this.actualColor = this.fetchColor(this.actualColorKey);
        }
        return this.actualColor;
    }

    private boolean hasMustContrastColor() {
        return this.mustContrastColor != null || this.mustContrastColorKey != null;
    }

    private boolean checkState(Color color, String string) {
        if (color == null && string == null) {
            throw new NullPointerException("Both color and key are null for " + this);
        }
        return color == null;
    }

    private Color fetchColor(String string) {
        Color color = UIManager.getColor(string);
        if (color == null) {
            color = this.fallback;
        }
        return color;
    }

    static Color deriveColor(Color color, Color color2, Color color3) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float[] fArray2 = Color.RGBtoHSB(color3.getRed(), color3.getGreen(), color3.getBlue(), null);
        float[] fArray3 = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null);
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        float[] fArray6 = RelativeColor.percentageDiff(fArray3, fArray);
        fArray4[0] = fArray3[0] + fArray6[0] * (fArray2[0] - fArray[0]);
        fArray4[1] = fArray3[1] + fArray6[1] * (fArray2[1] - fArray[1]);
        fArray4[2] = fArray3[2] + fArray6[2] * (fArray2[2] - fArray[2]);
        fArray5[0] = RelativeColor.saturate(fArray4[0]);
        fArray5[1] = RelativeColor.saturate(fArray4[1]);
        fArray5[2] = RelativeColor.saturate(fArray4[2]);
        if ((double)fArray2[1] > 0.1 && (double)fArray4[1] <= 0.1) {
            fArray4[1] = fArray4[2] * 0.25f;
            fArray4[2] = fArray4[2] - fArray4[2] * 0.25f;
        }
        Color color4 = new Color(Color.HSBtoRGB(fArray5[0], fArray5[1], fArray5[2]));
        return color4;
    }

    private static float[] percentageDiff(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[3];
        for (int i = 0; i < 3; ++i) {
            fArray3[i] = 1.0f - Math.abs(fArray[i] - fArray2[i]);
            if (fArray3[i] != 0.0f) continue;
            fArray3[i] = 1.0f - fArray[i];
        }
        return fArray3;
    }

    private static final void out(String string, float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(": ");
        for (int i = 0; i < fArray.length; ++i) {
            stringBuffer.append(Math.round(fArray[i] * 100.0f));
            if (i == fArray.length - 1) continue;
            stringBuffer.append(',');
            stringBuffer.append(' ');
        }
        System.err.println(stringBuffer.toString());
    }

    private static float saturate(float f) {
        return Math.max(0.0f, Math.min(1.0f, f));
    }

    static Color ensureContrast(Color color, Color color2) {
        float[] fArray = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null);
        float[] fArray2 = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float[] fArray3 = new float[3];
        System.arraycopy(fArray2, 0, fArray3, 0, 3);
        float f = Math.abs(fArray2[1] - fArray[1]);
        float f2 = Math.abs(fArray2[2] - fArray[2]);
        if ((double)fArray2[1] > 0.6 && (double)fArray3[1] > 0.6 || f2 < 0.45f && f < 0.4f) {
            fArray3[1] = fArray3[1] / 3.0f;
            f = Math.abs(fArray2[1] - fArray[1]);
        }
        if ((double)f2 < 0.3 || (double)f < 0.3 && (double)f2 < 0.5) {
            float f3 = 1.5f * (0.5f - fArray[2]);
            fArray3[2] = RelativeColor.saturate(fArray3[2] + f3);
        }
        Color color3 = new Color(Color.HSBtoRGB(fArray3[0], fArray3[1], fArray3[2]));
        return color3;
    }
}

