/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.spellchecker.spi.dictionary.Dictionary;
import org.netbeans.modules.spellchecker.spi.dictionary.ValidityType;

public class CompoundDictionary
implements Dictionary {
    private static final Logger LOGGER = Logger.getLogger(CompoundDictionary.class.getName());
    private Dictionary[] delegates;

    private CompoundDictionary(Dictionary ... delegates) {
        this.delegates = (Dictionary[])delegates.clone();
    }

    public static Dictionary create(Dictionary ... delegates) {
        return new CompoundDictionary(delegates);
    }

    public ValidityType validateWord(CharSequence word) {
        ValidityType result = ValidityType.INVALID;
        for (Dictionary d : this.delegates) {
            ValidityType thisResult = d.validateWord(word);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "validating word \"{0}\" using dictionary {1}, result: {2}", new Object[]{word, d.toString(), thisResult});
            }
            if (thisResult == ValidityType.VALID || thisResult == ValidityType.BLACKLISTED) {
                return thisResult;
            }
            if (thisResult != ValidityType.PREFIX_OF_VALID || result != ValidityType.INVALID) continue;
            result = ValidityType.PREFIX_OF_VALID;
        }
        return result;
    }

    public List<String> findValidWordsForPrefix(CharSequence word) {
        LinkedList<String> result = new LinkedList<String>();
        for (Dictionary d : this.delegates) {
            result.addAll(d.findValidWordsForPrefix(word));
        }
        return result;
    }

    public List<String> findProposals(CharSequence word) {
        LinkedList<String> result = new LinkedList<String>();
        for (Dictionary d : this.delegates) {
            result.addAll(d.findProposals(word));
        }
        return result;
    }
}

