/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetVcnTopologyRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String vcnId;
    private AccessLevel accessLevel;
    private Boolean queryCompartmentSubtree;
    private String opcRequestId;
    private String ifNoneMatch;
    private String cacheControl;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getVcnId() {
        return this.vcnId;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public Boolean getQueryCompartmentSubtree() {
        return this.queryCompartmentSubtree;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).vcnId(this.vcnId).accessLevel(this.accessLevel).queryCompartmentSubtree(this.queryCompartmentSubtree).opcRequestId(this.opcRequestId).ifNoneMatch(this.ifNoneMatch).cacheControl(this.cacheControl);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",vcnId=").append(String.valueOf(this.vcnId));
        sb.append(",accessLevel=").append(String.valueOf((Object)this.accessLevel));
        sb.append(",queryCompartmentSubtree=").append(String.valueOf(this.queryCompartmentSubtree));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifNoneMatch=").append(String.valueOf(this.ifNoneMatch));
        sb.append(",cacheControl=").append(String.valueOf(this.cacheControl));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetVcnTopologyRequest)) {
            return false;
        }
        GetVcnTopologyRequest other = (GetVcnTopologyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.vcnId, other.vcnId) && Objects.equals((Object)this.accessLevel, (Object)other.accessLevel) && Objects.equals(this.queryCompartmentSubtree, other.queryCompartmentSubtree) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifNoneMatch, other.ifNoneMatch) && Objects.equals(this.cacheControl, other.cacheControl);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.vcnId == null ? 43 : this.vcnId.hashCode());
        result = result * 59 + (this.accessLevel == null ? 43 : this.accessLevel.hashCode());
        result = result * 59 + (this.queryCompartmentSubtree == null ? 43 : this.queryCompartmentSubtree.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifNoneMatch == null ? 43 : this.ifNoneMatch.hashCode());
        result = result * 59 + (this.cacheControl == null ? 43 : this.cacheControl.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetVcnTopologyRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String vcnId = null;
        private AccessLevel accessLevel = null;
        private Boolean queryCompartmentSubtree = null;
        private String opcRequestId = null;
        private String ifNoneMatch = null;
        private String cacheControl = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder vcnId(String vcnId) {
            this.vcnId = vcnId;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder queryCompartmentSubtree(Boolean queryCompartmentSubtree) {
            this.queryCompartmentSubtree = queryCompartmentSubtree;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVcnTopologyRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.vcnId(o.getVcnId());
            this.accessLevel(o.getAccessLevel());
            this.queryCompartmentSubtree(o.getQueryCompartmentSubtree());
            this.opcRequestId(o.getOpcRequestId());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.cacheControl(o.getCacheControl());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVcnTopologyRequest build() {
            GetVcnTopologyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetVcnTopologyRequest buildWithoutInvocationCallback() {
            GetVcnTopologyRequest request = new GetVcnTopologyRequest();
            request.compartmentId = this.compartmentId;
            request.vcnId = this.vcnId;
            request.accessLevel = this.accessLevel;
            request.queryCompartmentSubtree = this.queryCompartmentSubtree;
            request.opcRequestId = this.opcRequestId;
            request.ifNoneMatch = this.ifNoneMatch;
            request.cacheControl = this.cacheControl;
            return request;
        }
    }

    public static enum AccessLevel implements BmcEnum
    {
        Any("ANY"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

