/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.parsing;

import java.util.ArrayList;
import java.util.List;
import jdk.jshell.SourceCodeAnalysis;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.jshell.model.ConsoleSection;
import org.netbeans.modules.jshell.model.JShellToken;
import org.netbeans.modules.jshell.model.Rng;
import org.netbeans.modules.jshell.parsing.ModelAccessor;
import org.netbeans.modules.jshell.parsing.ShellAccessBridge;

public class JShellParser {
    private final ShellAccessBridge shellAccess;
    private TokenSequence<JShellToken> sequence;
    private int startOffset;
    private int limit;
    private StringBuilder snippetText;
    private ConsoleSection section;
    private List<Rng> ranges = new ArrayList<Rng>();
    private List<Rng> snippets = new ArrayList<Rng>();
    private int snippetPrefixLen;
    private List<ConsoleSection> sectionList = new ArrayList<ConsoleSection>();
    private int lineContentsStart;
    private int lineStart;

    public JShellParser(ShellAccessBridge access, TokenSequence<JShellToken> seq, int initialPos, int limit) {
        this.shellAccess = access;
        this.startOffset = initialPos;
        this.sequence = seq;
        this.limit = limit;
    }

    private int p(int pos) {
        return this.startOffset + pos;
    }

    private void finishSection() {
        this.finishSection(this.sequence.offset());
    }

    private void finishSection(int eoffset) {
        if (this.section == null) {
            return;
        }
        ModelAccessor.INSTANCE.extendSection(this.section, this.p(this.lineContentsStart), this.p(eoffset), this.ranges, this.snippets);
        this.sectionList.add(this.section);
        this.section = null;
    }

    private void createSection(ConsoleSection.Type type) {
        this.createSection(type, this.sequence.token().length(), this.sequence.offset());
    }

    private void createSection(ConsoleSection.Type type, int l, int start) {
        if (this.section != null) {
            if (this.section != null && this.section.getType() == type) {
                int s = start;
                if (s + l >= this.limit) {
                    l = this.limit - s;
                }
                ModelAccessor.INSTANCE.extendSection(this.section, this.p(s), this.p(s + l), null, null);
                return;
            }
            this.finishSection();
        }
        if (this.lineStart + l >= this.limit) {
            l = this.limit - this.lineStart;
        }
        this.section = new ConsoleSection(this.p(this.lineStart), type, l);
        this.ranges = new ArrayList<Rng>();
        this.snippets = new ArrayList<Rng>();
    }

    private void addJavaSnippet(int start, int len) {
        int a = start;
        if (this.section != null && this.section.isIncomplete()) {
            int i = this.snippets.size() - 1;
            Rng prev = this.snippets.get(i);
            Rng r = new Rng(prev.start, prev.start + len);
            this.snippets.set(i, r);
        } else {
            int b = a + len;
            this.snippets.add(new Rng(this.p(a), this.p(b)));
        }
    }

    private void extendWithPart() {
        int ls = this.sequence.offset();
        int le = ls + this.sequence.token().length();
        this.extendWithPart(ls, le);
    }

    private void extendWithPart(int ls, int le) {
        if (le == this.limit + 1) {
            le = this.limit;
        }
        if (!this.ranges.isEmpty()) {
            int l = this.ranges.size() - 1;
            Rng r = this.ranges.get(l);
            int a = this.p(ls);
            if (r.end == a || r.start == a) {
                r = new Rng(r.start, this.p(le));
                this.ranges.set(l, r);
                ModelAccessor.INSTANCE.extendSection(this.section, r.start, r.end, null, null);
                return;
            }
        }
        Rng r = new Rng(this.p(ls), this.p(le));
        this.ranges.add(r);
        ModelAccessor.INSTANCE.extendSection(this.section, r.start, r.end, null, null);
    }

    private void addSnippetText(int pos, CharSequence text) {
        if (this.snippetText == null || this.section != null && !this.section.isIncomplete()) {
            this.snippetPrefixLen = 0;
            this.snippetText = new StringBuilder(text);
        } else {
            this.snippetPrefixLen = this.snippetText.length();
            this.snippetText.append(text);
        }
    }

    private void processJavaInput() {
        String input = this.snippetText.toString();
        int lpos = this.sequence.offset();
        CharSequence lineContents = this.sequence.token().text();
        if (!this.shellAccess.isInitialized()) {
            boolean empty = input.trim().isEmpty();
            int e = input.length();
            e = input.length();
            this.extendWithPart();
            ModelAccessor.INSTANCE.setSectionComplete(this.section, true);
            return;
        }
        int snipOffset = lpos;
        block5: while (true) {
            SourceCodeAnalysis.CompletionInfo info;
            String rem;
            int endPos = (rem = (info = this.shellAccess.analyzeInput(input)).remaining()) == null ? input.length() - 1 : input.length() - rem.length() - 1;
            int e = endPos;
            boolean empty = info.remaining().trim().isEmpty();
            switch (info.completeness()) {
                case DEFINITELY_INCOMPLETE: 
                case CONSIDERED_INCOMPLETE: {
                    this.addJavaSnippet(snipOffset, input.length());
                    ModelAccessor.INSTANCE.setSectionComplete(this.section, false);
                    break block5;
                }
                case EMPTY: {
                    break block5;
                }
                case COMPLETE_WITH_SEMI: 
                case UNKNOWN: 
                case COMPLETE: {
                    if (empty) {
                        e = input.length();
                    }
                    input = info.remaining();
                    this.addJavaSnippet(snipOffset, endPos + 1);
                    snipOffset += (e -= this.snippetPrefixLen);
                    ModelAccessor.INSTANCE.setSectionComplete(this.section, true);
                    if (!empty) continue block5;
                    break block5;
                }
                default: {
                    throw new AssertionError((Object)info.completeness().name());
                }
            }
            break;
        }
    }

    public void execute() {
        boolean f = true;
        boolean wasPrompt = false;
        int end = 0;
        while (this.sequence.moveNext() && (this.limit < 1 || this.sequence.offset() < this.limit)) {
            if (f) {
                this.lineStart = this.sequence.offset();
                f = false;
            }
            Token tukac = this.sequence.token();
            boolean resetJava = true;
            end = this.sequence.offset() + tukac.length();
            block0 : switch ((JShellToken)tukac.id()) {
                case COMMAND: 
                case COMMAND_PARAM: 
                case ERR_COMMAND: 
                case COMMAND_OPTION: 
                case COMMAND_STRING: {
                    this.createSection(ConsoleSection.Type.COMMAND);
                    this.extendWithPart();
                    break;
                }
                case PROMPT: {
                    this.finishSection();
                    this.lineContentsStart = this.sequence.offset() + tukac.length();
                    if (this.lineContentsStart >= this.limit) {
                        this.lineContentsStart = this.limit;
                    }
                    if (!this.sequence.moveNext()) {
                        this.createSection(ConsoleSection.Type.JAVA, 0, end);
                        this.extendWithPart(end, end);
                        break;
                    }
                    wasPrompt = true;
                    switch ((JShellToken)this.sequence.token().id()) {
                        case COMMAND: 
                        case COMMAND_PARAM: 
                        case ERR_COMMAND: 
                        case COMMAND_OPTION: 
                        case COMMAND_STRING: {
                            this.createSection(ConsoleSection.Type.COMMAND);
                            this.sequence.movePrevious();
                            break block0;
                        }
                    }
                    this.sequence.movePrevious();
                    this.createSection(ConsoleSection.Type.JAVA);
                    break;
                }
                case CONTINUATION_PROMPT: {
                    this.lineContentsStart = this.sequence.offset();
                    resetJava = false;
                    break;
                }
                case JAVA: {
                    if (!wasPrompt) {
                        this.createSection(ConsoleSection.Type.OUTPUT);
                        this.extendWithPart();
                        break;
                    }
                    this.createSection(ConsoleSection.Type.JAVA);
                    this.extendWithPart();
                    this.addSnippetText(this.sequence.offset(), tukac.text());
                    resetJava = false;
                    this.processJavaInput();
                    break;
                }
                case MESSAGE_MARK: {
                    this.lineContentsStart = this.sequence.offset();
                    this.createSection(ConsoleSection.Type.MESSAGE);
                    break;
                }
                case MESSAGE_TEXT: 
                case ERROR_MARKER: {
                    this.createSection(ConsoleSection.Type.MESSAGE);
                    this.extendWithPart();
                    break;
                }
                case OUTPUT: {
                    this.createSection(ConsoleSection.Type.OUTPUT);
                    this.extendWithPart();
                    break;
                }
                case WHITESPACE: {
                    if (this.section == null) {
                        this.createSection(ConsoleSection.Type.OUTPUT);
                    }
                    this.extendWithPart();
                    resetJava = false;
                    break;
                }
                default: {
                    throw new AssertionError((Object)((JShellToken)tukac.id()).name());
                }
            }
            CharSequence text = tukac.text();
            if (text.length() > 0 && text.charAt(text.length() - 1) == '\n') {
                this.lineContentsStart = this.lineStart = this.sequence.offset() + tukac.length();
            }
            if (!resetJava) continue;
            this.snippetText = null;
        }
        this.finishSection(end);
    }

    public List<ConsoleSection> sections() {
        return this.sectionList;
    }
}

