/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.commit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class DeleteLocalAction
extends ContextAction {
    public static final int LOCALLY_DELETABLE_MASK = 4100;

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Delete";
    }

    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        return Mercurial.getInstance().getFileStatusCache().listFiles(context, 4100).length > 0;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        final Set files = context.getRootFiles();
        for (File f : files) {
            if ((cache.getCachedStatus(f).getStatus() & 0x1004) != 0) continue;
            return;
        }
        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DeleteLocalAction.class, (String)"CTL_DeleteLocal_Prompt"));
        descriptor.setTitle(NbBundle.getMessage(DeleteLocalAction.class, (String)"CTL_DeleteLocal_Title"));
        descriptor.setMessageType(2);
        descriptor.setOptionType(0);
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        if (res != NotifyDescriptor.YES_OPTION) {
            return;
        }
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                final Map<File, Set<File>> sortedFiles = HgUtils.sortUnderRepository(files);
                try {
                    HgUtils.runWithoutIndexing(new Callable<Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Void call() throws Exception {
                            for (Map.Entry e : sortedFiles.entrySet()) {
                                try {
                                    HgCommand.doRevert((File)e.getKey(), new ArrayList<File>((Collection)e.getValue()), null, false, OutputLogger.getLogger(null));
                                }
                                catch (HgException ex) {
                                    Mercurial.LOG.log(Level.INFO, null, ex);
                                }
                                for (File file : (Set)e.getValue()) {
                                    if (this.isCanceled()) {
                                        return null;
                                    }
                                    FileObject fo = FileUtil.toFileObject((File)file);
                                    if (fo == null) continue;
                                    FileLock lock = null;
                                    try {
                                        lock = fo.lock();
                                        fo.delete(lock);
                                    }
                                    catch (IOException ex) {
                                        Mercurial.LOG.log(Level.SEVERE, NbBundle.getMessage(DeleteLocalAction.class, (String)"MSG_Cannot_lock", (Object)file.getAbsolutePath()), e);
                                    }
                                    finally {
                                        if (lock == null) continue;
                                        lock.releaseLock();
                                    }
                                }
                            }
                            return null;
                        }
                    }, files.toArray(new File[0]));
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
            }
        };
        support.start(Mercurial.getInstance().getRequestProcessor(), NbBundle.getMessage(DeleteLocalAction.class, (String)"LBL_DeleteLocalAction.progress"));
    }
}

