/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lsp.InlayHint;
import org.netbeans.api.lsp.Position;
import org.netbeans.modules.java.editor.base.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.base.semantic.SemanticHighlighterBase;
import org.netbeans.spi.lsp.InlayHintsProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public class InlayHintsProviderImpl
implements InlayHintsProvider {
    private static final Set<String> SUPPORTED_HINT_TYPES = Set.of("parameter", "chained", "var");

    public Set<String> supportedHintTypes() {
        return SUPPORTED_HINT_TYPES;
    }

    public CompletableFuture<List<? extends InlayHint>> inlayHints(InlayHintsProvider.Context context) {
        CompletableFuture<List<? extends InlayHint>> result = new CompletableFuture<List<? extends InlayHint>>();
        JavaSource js = JavaSource.forFileObject((FileObject)context.getFile());
        if (js != null) {
            final ArrayList hints = new ArrayList();
            try {
                js.runUserActionTask(cc -> {
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    final SemanticHighlighterBase.Settings settings = new SemanticHighlighterBase.Settings(context.getRequestedHintTypes().contains("parameter"), context.getRequestedHintTypes().contains("chained"), context.getRequestedHintTypes().contains("var"));
                    Document doc = cc.getSnapshot().getSource().getDocument(true);
                    final int start = context.getRange().getStartOffset();
                    final int end = context.getRange().getEndOffset();
                    new SemanticHighlighterBase(){

                        protected boolean process(CompilationInfo info, Document doc) {
                            this.process(info, doc, settings, new SemanticHighlighterBase.ErrorDescriptionSetter(){

                                public void setHighlights(Document doc, Collection<Pair<int[], ColoringAttributes.Coloring>> highlights, Map<int[], String> preText) {
                                    for (Map.Entry<int[], String> e : preText.entrySet()) {
                                        if (e.getKey()[0] < start || e.getKey()[0] > end) continue;
                                        InlayHint hint = new InlayHint((Position)new PositionImpl(e.getKey()[0]), e.getValue());
                                        hints.add(hint);
                                    }
                                }

                                public void setColorings(Document doc, Map<Token, ColoringAttributes.Coloring> colorings) {
                                }
                            });
                            return true;
                        }
                    }.process((CompilationInfo)cc, doc);
                }, true);
                result.complete(hints);
            }
            catch (IOException ex) {
                result.completeExceptionally(ex);
            }
        }
        return result;
    }

    private static final class PositionImpl
    implements Position {
        private final int offset;

        public PositionImpl(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

