/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.base.semantic;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.editor.base.semantic.Utilities;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.hints.unused.UsedDetector;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class UnusedDetector {
    private static final Object RESULTS_KEY = new Object();
    private static final Object CLASS_INDEX_KEY = new Object();
    private static Field signatureAccessField;
    private static final Set<String> SERIALIZABLE_SIGNATURES;
    private static final Set<ElementKind> LOCAL_VARIABLES;

    public static List<UnusedDescription> findUnused(CompilationInfo info, Callable<Boolean> cancel) {
        List cached = (List)info.getCachedValue(RESULTS_KEY);
        if (cached != null) {
            return cached;
        }
        UnusedVisitor uv = new UnusedVisitor(info);
        uv.scan(info.getCompilationUnit(), null);
        AtomicReference usedDetectors = new AtomicReference();
        BiFunction<Element, TreePath, Boolean> markedAsUsed = (el, path) -> {
            if (usedDetectors.get() == null) {
                usedDetectors.set(UnusedDetector.collectUsedDetectors(info));
            }
            for (UsedDetector detector : (List)usedDetectors.get()) {
                if (!detector.isUsed(el, path)) continue;
                return true;
            }
            return false;
        };
        ArrayList<UnusedDescription> result = new ArrayList<UnusedDescription>();
        for (Map.Entry<Element, TreePath> e : uv.element2Declaration.entrySet()) {
            boolean isRead;
            boolean isPkgPrivate;
            Element el2 = e.getKey();
            TreePath declaration = e.getValue();
            Set uses = uv.useTypes.getOrDefault(el2, Collections.emptySet());
            boolean isPrivate = el2.getModifiers().contains((Object)Modifier.PRIVATE);
            boolean bl = isPkgPrivate = !isPrivate && !el2.getModifiers().contains((Object)Modifier.PUBLIC) && !el2.getModifiers().contains((Object)Modifier.PROTECTED);
            if (UnusedDetector.isLocalVariableClosure(el2)) {
                boolean isWritten = uses.contains((Object)UseTypes.WRITTEN);
                isRead = uses.contains((Object)UseTypes.READ);
                if (!(isWritten || isRead || markedAsUsed.apply(el2, declaration).booleanValue())) {
                    result.add(new UnusedDescription(el2, declaration, isPkgPrivate, UnusedReason.NOT_WRITTEN_READ));
                    continue;
                }
                if (!isWritten && !markedAsUsed.apply(el2, declaration).booleanValue()) {
                    result.add(new UnusedDescription(el2, declaration, isPkgPrivate, UnusedReason.NOT_WRITTEN));
                    continue;
                }
                if (isRead || markedAsUsed.apply(el2, declaration).booleanValue()) continue;
                result.add(new UnusedDescription(el2, declaration, isPkgPrivate, UnusedReason.NOT_READ));
                continue;
            }
            if (el2.getKind().isField() && (isPrivate || isPkgPrivate)) {
                if (UnusedDetector.isSerialSpecField(info, el2) || UnusedDetector.lookedUpElement(el2, uv.type2LookedUpFields, uv.allStringLiterals)) continue;
                boolean isWritten = uses.contains((Object)UseTypes.WRITTEN);
                isRead = uses.contains((Object)UseTypes.READ);
                if (!isWritten && !isRead) {
                    if (!isPrivate && !UnusedDetector.isUnusedInPkg(info, el2, cancel) || markedAsUsed.apply(el2, declaration).booleanValue()) continue;
                    result.add(new UnusedDescription(el2, declaration, isPkgPrivate, UnusedReason.NOT_WRITTEN_READ));
                    continue;
                }
                if (!isWritten && !markedAsUsed.apply(el2, declaration).booleanValue()) {
                    result.add(new UnusedDescription(el2, declaration, isPkgPrivate, UnusedReason.NOT_WRITTEN));
                    continue;
                }
                if (isRead || !isPrivate && !UnusedDetector.isUnusedInPkg(info, el2, cancel) || markedAsUsed.apply(el2, declaration).booleanValue()) continue;
                result.add(new UnusedDescription(el2, declaration, isPkgPrivate, UnusedReason.NOT_READ));
                continue;
            }
            if ((el2.getKind() == ElementKind.CONSTRUCTOR || el2.getKind() == ElementKind.METHOD) && (isPrivate || isPkgPrivate)) {
                ExecutableElement method = (ExecutableElement)el2;
                if (UnusedDetector.isSerializationMethod(info, method) || uses.contains((Object)UseTypes.USED) || info.getElementUtilities().overridesMethod(method) || UnusedDetector.lookedUpElement(el2, uv.type2LookedUpMethods, uv.allStringLiterals) || SourceUtils.isMainMethod((ExecutableElement)method) || !isPrivate && !UnusedDetector.isUnusedInPkg(info, el2, cancel) || markedAsUsed.apply(el2, declaration).booleanValue()) continue;
                result.add(new UnusedDescription(el2, declaration, isPkgPrivate, UnusedReason.NOT_USED));
                continue;
            }
            if (!el2.getKind().isClass() && !el2.getKind().isInterface() || !isPrivate && !isPkgPrivate || uses.contains((Object)UseTypes.USED) || !isPrivate && !UnusedDetector.isUnusedInPkg(info, el2, cancel) || markedAsUsed.apply(el2, declaration).booleanValue()) continue;
            result.add(new UnusedDescription(el2, declaration, isPkgPrivate, UnusedReason.NOT_USED));
        }
        info.putCachedValue(RESULTS_KEY, result, CompilationInfo.CacheClearPolicy.ON_CHANGE);
        return result;
    }

    private static boolean isSerialSpecField(CompilationInfo info, Element el) {
        if (el.getModifiers().contains((Object)Modifier.FINAL) && el.getModifiers().contains((Object)Modifier.STATIC)) {
            if (!UnusedDetector.isInSerializableOrExternalizable(info, el)) {
                return false;
            }
            if (info.getTypes().getPrimitiveType(TypeKind.LONG).equals(el.asType()) && el.getSimpleName().toString().equals("serialVersionUID")) {
                return true;
            }
            if (el.getSimpleName().contentEquals("serialPersistentFields")) {
                return true;
            }
        }
        return false;
    }

    private static boolean isInSerializableOrExternalizable(CompilationInfo info, Element e) {
        Element encl = e.getEnclosingElement();
        if (encl == null || !encl.getKind().isClass()) {
            return true;
        }
        TypeMirror m = encl.asType();
        if (m == null || m.getKind() != TypeKind.DECLARED) {
            return true;
        }
        TypeElement serEl = info.getElements().getTypeElement("java.io.Serializable");
        TypeElement extEl = info.getElements().getTypeElement("java.io.Externalizable");
        if (serEl == null || extEl == null) {
            return true;
        }
        if (info.getTypes().isSubtype(m, serEl.asType())) {
            return true;
        }
        return info.getTypes().isSubtype(m, extEl.asType());
    }

    private static String _getSignatureHack(ElementHandle<ExecutableElement> eh) {
        try {
            String[] signs;
            if (signatureAccessField == null) {
                try {
                    Field f = ElementHandle.class.getDeclaredField("signatures");
                    f.setAccessible(true);
                    signatureAccessField = f;
                }
                catch (NoSuchFieldException | SecurityException ex) {
                    return "";
                }
            }
            if ((signs = (String[])signatureAccessField.get(eh)) == null || signs.length != 3) {
                return "";
            }
            return signs[1] + signs[2];
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            return "";
        }
    }

    private static boolean isSerializationMethod(CompilationInfo info, ExecutableElement method) {
        if (!UnusedDetector.isInSerializableOrExternalizable(info, method)) {
            return false;
        }
        ElementHandle eh = ElementHandle.create((Element)method);
        String sign = UnusedDetector._getSignatureHack((ElementHandle<ExecutableElement>)eh);
        return SERIALIZABLE_SIGNATURES.contains(sign);
    }

    private static boolean isLocalVariableClosure(Element el) {
        return el.getKind() == ElementKind.PARAMETER || LOCAL_VARIABLES.contains((Object)el.getKind());
    }

    private static boolean lookedUpElement(Element element, Map<Element, Set<String>> type2LookedUp, Set<String> allStringLiterals) {
        String name = element.getKind() == ElementKind.CONSTRUCTOR ? "<init>" : element.getSimpleName().toString();
        return UnusedDetector.isLookedUp(element.getEnclosingElement(), name, type2LookedUp, allStringLiterals) || UnusedDetector.isLookedUp(null, name, type2LookedUp, allStringLiterals);
    }

    private static boolean isLookedUp(Element owner, String name, Map<Element, Set<String>> type2LookedUp, Set<String> allStringLiterals) {
        Set lookedUp = type2LookedUp.getOrDefault(owner, Collections.emptySet());
        return lookedUp.contains(name) || allStringLiterals.contains(name) && lookedUp.contains(null);
    }

    private static boolean isUnusedInPkg(CompilationInfo info, Element el, Callable<Boolean> cancel) {
        EnumSet<ClassIndex.SearchKind> searchKinds;
        TypeElement typeElement;
        final Set<String> packageSet = Collections.singleton(info.getElements().getPackageOf(el).getQualifiedName().toString());
        Set<1> scope = Collections.singleton(new ClassIndex.SearchScopeType(){

            public Set<? extends String> getPackages() {
                return packageSet;
            }

            public boolean isSources() {
                return true;
            }

            public boolean isDependencies() {
                return false;
            }
        });
        switch (el.getKind()) {
            case FIELD: {
                typeElement = info.getElementUtilities().enclosingTypeElement(el);
                searchKinds = EnumSet.of(ClassIndex.SearchKind.FIELD_REFERENCES);
                break;
            }
            case METHOD: 
            case CONSTRUCTOR: {
                typeElement = info.getElementUtilities().enclosingTypeElement(el);
                searchKinds = EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES);
                break;
            }
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                List topLevelElements = info.getTopLevelElements();
                if (topLevelElements.size() == 1 && topLevelElements.get(0) == el) {
                    return false;
                }
                typeElement = (TypeElement)el;
                searchKinds = EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES);
                break;
            }
            default: {
                return true;
            }
        }
        FileObject fileObject = info.getFileObject();
        final ElementHandle eh = ElementHandle.create((Element)el);
        if (PkgScanResultCache.getCachedUsedInPkg(fileObject, (ElementHandle<Element>)eh)) {
            return false;
        }
        ClassIndex classIndex = UnusedDetector.getCachedClassIndex(fileObject, info);
        Set res = classIndex.getResources(ElementHandle.create((Element)typeElement), searchKinds, scope);
        if (res != null) {
            for (FileObject fo : res) {
                try {
                    if (Boolean.TRUE.equals(cancel.call())) {
                        return false;
                    }
                    if (fo == fileObject) continue;
                    JavaSource js = JavaSource.forFileObject((FileObject)fo);
                    if (js == null) {
                        return false;
                    }
                    final AtomicBoolean found = new AtomicBoolean();
                    js.runUserActionTask(cc -> {
                        cc.toPhase(JavaSource.Phase.RESOLVED);
                        new ErrorAwareTreePathScanner<Void, Element>(){

                            public Void scan(Tree tree, Element p) {
                                if (!found.get() && tree != null) {
                                    Element element = cc.getTrees().getElement(new TreePath(this.getCurrentPath(), tree));
                                    if (element != null && eh.signatureEquals(element)) {
                                        found.set(true);
                                        return null;
                                    }
                                    super.scan(tree, (Object)p);
                                }
                                return null;
                            }
                        }.scan(new TreePath(cc.getCompilationUnit()), (Object)el);
                    }, true);
                    if (!found.get()) continue;
                    PkgScanResultCache.markFoundInFile(fileObject, fo, (ElementHandle<Element>)ElementHandle.create((Element)el));
                    return false;
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return true;
        }
        return false;
    }

    private static ClassIndex getCachedClassIndex(FileObject fileObject, CompilationInfo info) {
        ClassIndex classIndex = (ClassIndex)info.getCachedValue(CLASS_INDEX_KEY);
        if (classIndex == null) {
            ClasspathInfo cpInfo;
            Project prj = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (prj != null) {
                SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)prj).getSourceGroups("java");
                FileObject[] roots = new FileObject[sourceGroups.length];
                for (int i = 0; i < sourceGroups.length; ++i) {
                    SourceGroup sourceGroup = sourceGroups[i];
                    roots[i] = sourceGroup.getRootFolder();
                }
                cpInfo = ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPathSupport.createClassPath((FileObject[])roots));
            } else {
                cpInfo = info.getClasspathInfo();
            }
            classIndex = cpInfo.getClassIndex();
            info.putCachedValue(CLASS_INDEX_KEY, (Object)classIndex, CompilationInfo.CacheClearPolicy.ON_CHANGE);
        }
        return classIndex;
    }

    private static List<UsedDetector> collectUsedDetectors(CompilationInfo info) {
        ArrayList<UsedDetector> detectors = new ArrayList<UsedDetector>();
        for (UsedDetector.Factory factory : Lookup.getDefault().lookupAll(UsedDetector.Factory.class)) {
            UsedDetector detector = factory.create(info);
            if (detector == null) continue;
            detectors.add(detector);
        }
        return detectors;
    }

    static {
        SERIALIZABLE_SIGNATURES = new HashSet<String>(Arrays.asList("writeObject(Ljava/io/ObjectOutputStream;)V", "readObject(Ljava/io/ObjectInputStream;)V", "readResolve()Ljava/lang/Object;", "writeReplace()Ljava/lang/Object;", "readObjectNoData()V"));
        LOCAL_VARIABLES = EnumSet.of(ElementKind.LOCAL_VARIABLE, ElementKind.RESOURCE_VARIABLE, ElementKind.EXCEPTION_PARAMETER, ElementKind.BINDING_VARIABLE);
    }

    private static final class UnusedVisitor
    extends ErrorAwareTreePathScanner<Void, Void> {
        private final Map<Element, Set<UseTypes>> useTypes = new HashMap<Element, Set<UseTypes>>();
        private final Map<Element, TreePath> element2Declaration = new HashMap<Element, TreePath>();
        private final Map<Element, Set<String>> type2LookedUpMethods = new HashMap<Element, Set<String>>();
        private final Map<Element, Set<String>> type2LookedUpFields = new HashMap<Element, Set<String>>();
        private final Set<String> allStringLiterals = new HashSet<String>();
        private final TypeElement methodHandlesLookup;
        private final CompilationInfo info;
        private ExecutableElement recursionDetector;

        public UnusedVisitor(CompilationInfo info) {
            this.info = info;
            this.methodHandlesLookup = info.getElements().getTypeElement(MethodHandles.Lookup.class.getCanonicalName());
        }

        public Void visitIdentifier(IdentifierTree node, Void p) {
            this.handleUse();
            return (Void)super.visitIdentifier(node, (Object)p);
        }

        public Void visitMemberSelect(MemberSelectTree node, Void p) {
            this.handleUse();
            return (Void)super.visitMemberSelect(node, (Object)p);
        }

        public Void visitMemberReference(MemberReferenceTree node, Void p) {
            this.handleUse();
            return (Void)super.visitMemberReference(node, (Object)p);
        }

        public Void visitNewClass(NewClassTree node, Void p) {
            this.handleUse();
            return (Void)super.visitNewClass(node, (Object)p);
        }

        private void handleUse() {
            boolean isPkgPrivate;
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            if (el == null) {
                return;
            }
            boolean isPrivate = el.getModifiers().contains((Object)Modifier.PRIVATE);
            boolean bl = isPkgPrivate = !isPrivate && !el.getModifiers().contains((Object)Modifier.PUBLIC) && !el.getModifiers().contains((Object)Modifier.PROTECTED);
            if (UnusedDetector.isLocalVariableClosure(el) || el.getKind().isField() && isPrivate | isPkgPrivate) {
                TreePath effectiveUse = this.getCurrentPath();
                boolean isWrite = false;
                boolean isRead = false;
                block5: while (true) {
                    TreePath parent = effectiveUse.getParentPath();
                    switch (parent.getLeaf().getKind()) {
                        case ASSIGNMENT: {
                            AssignmentTree at = (AssignmentTree)parent.getLeaf();
                            if (at.getVariable() == effectiveUse.getLeaf()) {
                                isWrite = true;
                                break block5;
                            }
                            if (at.getExpression() == effectiveUse.getLeaf()) {
                                isRead = true;
                            }
                            break block5;
                        }
                        case AND_ASSIGNMENT: 
                        case DIVIDE_ASSIGNMENT: 
                        case LEFT_SHIFT_ASSIGNMENT: 
                        case MINUS_ASSIGNMENT: 
                        case MULTIPLY_ASSIGNMENT: 
                        case OR_ASSIGNMENT: 
                        case PLUS_ASSIGNMENT: 
                        case REMAINDER_ASSIGNMENT: 
                        case RIGHT_SHIFT_ASSIGNMENT: 
                        case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
                        case XOR_ASSIGNMENT: {
                            CompoundAssignmentTree cat = (CompoundAssignmentTree)parent.getLeaf();
                            if (cat.getVariable() == effectiveUse.getLeaf()) {
                                effectiveUse = parent;
                                continue block5;
                            }
                            isRead = true;
                            break block5;
                        }
                        case EXPRESSION_STATEMENT: {
                            break block5;
                        }
                        default: {
                            isRead = true;
                            break block5;
                        }
                    }
                    break;
                }
                if (isWrite) {
                    this.addUse(el, UseTypes.WRITTEN);
                }
                if (isRead) {
                    this.addUse(el, UseTypes.READ);
                }
            } else if (isPrivate | isPkgPrivate && (el.getKind() != ElementKind.METHOD || this.recursionDetector != el)) {
                this.addUse(el, UseTypes.USED);
            }
        }

        private void addUse(Element el, UseTypes type) {
            this.useTypes.computeIfAbsent(el, x -> EnumSet.noneOf(UseTypes.class)).add(type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void visitClass(ClassTree node, Void p) {
            ExecutableElement prevRecursionDetector = this.recursionDetector;
            try {
                this.recursionDetector = null;
                this.handleDeclaration(this.getCurrentPath());
                Void void_ = (Void)super.visitClass(node, (Object)p);
                return void_;
            }
            finally {
                this.recursionDetector = prevRecursionDetector;
            }
        }

        public Void visitVariable(VariableTree node, Void p) {
            this.handleDeclaration(this.getCurrentPath());
            return (Void)super.visitVariable(node, (Object)p);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void visitMethod(MethodTree node, Void p) {
            ExecutableElement prevRecursionDetector = this.recursionDetector;
            try {
                Element el = this.info.getTrees().getElement(this.getCurrentPath());
                this.recursionDetector = el != null && el.getKind() == ElementKind.METHOD ? (ExecutableElement)el : null;
                this.handleDeclaration(this.getCurrentPath());
                Void void_ = (Void)super.visitMethod(node, (Object)p);
                return void_;
            }
            finally {
                this.recursionDetector = prevRecursionDetector;
            }
        }

        private void handleDeclaration(TreePath path) {
            VariableTree vt;
            Element el = this.info.getTrees().getElement(path);
            if (el == null) {
                return;
            }
            this.element2Declaration.put(el, path);
            if (el.getKind() == ElementKind.PARAMETER) {
                this.addUse(el, UseTypes.WRITTEN);
                boolean read = true;
                Tree parent = path.getParentPath().getLeaf();
                if (parent.getKind() == Tree.Kind.METHOD) {
                    MethodTree method = (MethodTree)parent;
                    Set<Modifier> mods = method.getModifiers().getFlags();
                    if (method.getParameters().contains(path.getLeaf()) && mods.contains((Object)Modifier.PRIVATE) && !mods.contains((Object)Modifier.ABSTRACT) && !mods.contains((Object)Modifier.NATIVE)) {
                        read = false;
                    }
                }
                if (read) {
                    this.addUse(el, UseTypes.READ);
                }
            } else if (el.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                this.addUse(el, UseTypes.READ);
                this.addUse(el, UseTypes.WRITTEN);
            } else if (el.getKind() == ElementKind.BINDING_VARIABLE) {
                this.addUse(el, UseTypes.WRITTEN);
            } else if (el.getKind() == ElementKind.LOCAL_VARIABLE) {
                Tree parent = path.getParentPath().getLeaf();
                if (parent.getKind() == Tree.Kind.ENHANCED_FOR_LOOP && ((EnhancedForLoopTree)parent).getVariable() == path.getLeaf()) {
                    this.addUse(el, UseTypes.WRITTEN);
                }
            } else if (Utilities.toRecordComponent(el).getKind() == ElementKind.RECORD_COMPONENT) {
                this.addUse(el, UseTypes.READ);
                this.addUse(el, UseTypes.WRITTEN);
            } else if (el.getKind().isField()) {
                this.addUse(el, UseTypes.WRITTEN);
            } else if (el.getKind() == ElementKind.CONSTRUCTOR && el.getModifiers().contains((Object)Modifier.PRIVATE) && ((ExecutableElement)el).getParameters().isEmpty()) {
                TypeElement encl = (TypeElement)el.getEnclosingElement();
                TypeElement jlObject = this.info.getElements().getTypeElement("java.lang.Object");
                boolean utility = !encl.getModifiers().contains((Object)Modifier.ABSTRACT) && encl.getInterfaces().isEmpty() && (jlObject == null || this.info.getTypes().isSameType(encl.getSuperclass(), jlObject.asType()));
                for (Element element : el.getEnclosingElement().getEnclosedElements()) {
                    if (element.getKind() == ElementKind.CONSTRUCTOR && !element.equals(el)) {
                        utility = false;
                        break;
                    }
                    if (!element.getKind().isField() && element.getKind() != ElementKind.METHOD || element.getModifiers().contains((Object)Modifier.STATIC)) continue;
                    utility = false;
                    break;
                }
                if (utility) {
                    this.addUse(el, UseTypes.USED);
                }
            }
            if (path.getLeaf().getKind() == Tree.Kind.VARIABLE && (vt = (VariableTree)path.getLeaf()).getInitializer() != null) {
                this.addUse(el, UseTypes.WRITTEN);
            }
        }

        public Void visitLiteral(LiteralTree node, Void p) {
            if (node.getKind() == Tree.Kind.STRING_LITERAL) {
                this.allStringLiterals.add((String)node.getValue());
            }
            return (Void)super.visitLiteral(node, (Object)p);
        }

        public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
            Element invoked = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getMethodSelect()));
            if (invoked != null && invoked.getEnclosingElement() == this.methodHandlesLookup && !node.getArguments().isEmpty()) {
                ExpressionTree name;
                MemberSelectTree mst;
                ExpressionTree clazz = node.getArguments().get(0);
                Element lookupType = null;
                if (clazz.getKind() == Tree.Kind.MEMBER_SELECT && (mst = (MemberSelectTree)clazz).getIdentifier().contentEquals("class")) {
                    lookupType = this.info.getTrees().getElement(new TreePath(new TreePath(this.getCurrentPath(), clazz), mst.getExpression()));
                }
                String lookupName = null;
                if (node.getArguments().size() > 1 && (name = node.getArguments().get(1)).getKind() == Tree.Kind.STRING_LITERAL) {
                    lookupName = (String)((LiteralTree)name).getValue();
                }
                switch (invoked.getSimpleName().toString()) {
                    case "findStatic": 
                    case "findVirtual": 
                    case "findSpecial": {
                        this.type2LookedUpMethods.computeIfAbsent(lookupType, t -> new HashSet()).add(lookupName);
                        break;
                    }
                    case "findConstructor": {
                        this.type2LookedUpMethods.computeIfAbsent(lookupType, t -> new HashSet()).add("<init>");
                        break;
                    }
                    case "findGetter": 
                    case "findSetter": 
                    case "findStaticGetter": 
                    case "findStaticSetter": 
                    case "findStaticVarHandle": 
                    case "findVarHandle": {
                        this.type2LookedUpFields.computeIfAbsent(lookupType, t -> new HashSet()).add(lookupName);
                    }
                }
            }
            return (Void)super.visitMethodInvocation(node, (Object)p);
        }
    }

    private static enum UseTypes {
        READ,
        WRITTEN,
        USED;

    }

    public record UnusedDescription(Element unusedElement, TreePath unusedElementPath, boolean packagePrivate, UnusedReason reason) {
    }

    public static enum UnusedReason {
        NOT_WRITTEN_READ("neither read or written to"),
        NOT_WRITTEN("never written to"),
        NOT_READ("never read"),
        NOT_USED("never used");

        private final String text;

        private UnusedReason(String text) {
            this.text = text;
        }
    }

    private static class PkgScanResultCache {
        private static FileObject lastSource;
        private static Map<ElementHandle<Element>, Usage> cache;

        private PkgScanResultCache() {
        }

        private static void markFoundInFile(FileObject source, FileObject pkgLocalFile, ElementHandle<Element> signature) {
            if (source == pkgLocalFile) {
                throw new IllegalArgumentException();
            }
            lastSource = source;
            cache.put(signature, new Usage(pkgLocalFile, Instant.now()));
        }

        private static boolean getCachedUsedInPkg(FileObject root, ElementHandle<Element> signature) {
            if (lastSource == null) {
                return false;
            }
            if (lastSource != root) {
                lastSource = null;
                cache = new HashMap<ElementHandle<Element>, Usage>();
                return false;
            }
            Usage usage = cache.get(signature);
            if (usage == null) {
                return false;
            }
            if (usage.inFile().lastModified().toInstant().isAfter(usage.markedTime())) {
                cache.remove(signature);
                return false;
            }
            return true;
        }

        static {
            cache = new HashMap<ElementHandle<Element>, Usage>();
        }

        private record Usage(FileObject inFile, Instant markedTime) {
        }
    }
}

