/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class SeverityLevel
implements Comparable,
Serializable {
    private static final int SEVERITYCODE_IGNORE = 10;
    private static final int SEVERITYCODE_INFO = 20;
    private static final int SEVERITYCODE_WARNING = 30;
    private static final int SEVERITYCODE_ERROR = 40;
    private static final String SEVERITYNAME_IGNORE = "ignore";
    private static final String SEVERITYNAME_INFO = "info";
    private static final String SEVERITYNAME_WARNING = "warning";
    private static final String SEVERITYNAME_ERROR = "error";
    public static final SeverityLevel IGNORE = new SeverityLevel(10, "ignore");
    public static final SeverityLevel INFO = new SeverityLevel(20, "info");
    public static final SeverityLevel WARNING = new SeverityLevel(30, "warning");
    public static final SeverityLevel ERROR = new SeverityLevel(40, "error");
    private static final Map NAME_TO_LEVEL = new HashMap();
    private final int mCode;
    private final String mName;

    public String toString() {
        return "Severity[" + this.mCode + " (" + this.mName + ")]";
    }

    public String getName() {
        return this.mName;
    }

    public int compareTo(Object aObject) {
        SeverityLevel severity = (SeverityLevel)aObject;
        return this.mCode - severity.mCode;
    }

    public boolean equals(Object aObj) {
        boolean result = false;
        if (aObj instanceof SeverityLevel && ((SeverityLevel)aObj).mCode == this.mCode) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        return this.mCode;
    }

    private SeverityLevel(int aCode, String aName) {
        this.mCode = aCode;
        this.mName = aName;
    }

    public static SeverityLevel getInstance(String aSeverityName) {
        String severityName = aSeverityName.trim().toLowerCase();
        SeverityLevel retVal = (SeverityLevel)NAME_TO_LEVEL.get(severityName);
        if (retVal == null) {
            throw new IllegalArgumentException(severityName);
        }
        return retVal;
    }

    private Object readResolve() {
        return SeverityLevel.getInstance(this.mName);
    }

    static {
        NAME_TO_LEVEL.put(SEVERITYNAME_IGNORE, IGNORE);
        NAME_TO_LEVEL.put(SEVERITYNAME_INFO, INFO);
        NAME_TO_LEVEL.put(SEVERITYNAME_WARNING, WARNING);
        NAME_TO_LEVEL.put(SEVERITYNAME_ERROR, ERROR);
    }
}

