/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryStack<T> {
    private T[] myStack;
    private int mySize;
    private int myLimit = 0;
    private int myPosition = 0;

    public HistoryStack(int size) {
        this.mySize = size;
        this.myStack = new Object[size];
    }

    public boolean hasNext() {
        return this.myPosition < this.myLimit;
    }

    public boolean hasPrev() {
        return this.myPosition > 0;
    }

    public T prev() {
        --this.myPosition;
        return this.myStack[this.myPosition];
    }

    public T next() {
        ++this.myPosition;
        return this.myStack[this.myPosition - 1];
    }

    public void add(T item) {
        if (this.myPosition < this.mySize) {
            this.myStack[this.myPosition] = item;
            ++this.myPosition;
        } else {
            System.arraycopy(this.myStack, 1, this.myStack, 0, this.mySize - 1);
            this.myStack[this.myPosition - 1] = item;
        }
        this.myLimit = this.myPosition;
    }
}

