/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.panelsearch.items;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.zaproxy.zap.view.panelsearch.HighlightedComponent;
import org.zaproxy.zap.view.panelsearch.HighlighterUtils;
import org.zaproxy.zap.view.panelsearch.SearchQuery;
import org.zaproxy.zap.view.panelsearch.items.AbstractComponentSearch;
import org.zaproxy.zap.view.panelsearch.items.ComboBoxElement;

public class ComboBoxElementSearch
extends AbstractComponentSearch<ComboBoxElement> {
    @Override
    protected boolean isSearchMatchingInternal(ComboBoxElement component, SearchQuery query) {
        return query.match(component.getItem().toString());
    }

    @Override
    protected HighlightedComponent highlightInternal(ComboBoxElement component) {
        HighlightComboBoxItemRenderer cellRenderer = this.wrapComboBoxItemRenderer(component);
        cellRenderer.addHighlightedIndex(component.getItemIndex());
        return new HighlightedComponent(component);
    }

    @Override
    protected void undoHighlightInternal(HighlightedComponent highlightedComponent, ComboBoxElement component) {
        this.revertWrappedComboBoxItemRenderer(component);
    }

    private HighlightComboBoxItemRenderer wrapComboBoxItemRenderer(ComboBoxElement component) {
        if (!(this.getRenderer(component) instanceof HighlightComboBoxItemRenderer)) {
            ListCellRenderer<Object> currentRenderer = this.getRenderer(component);
            this.setRenderer(component, new HighlightComboBoxItemRenderer(currentRenderer));
        }
        return (HighlightComboBoxItemRenderer)this.getRenderer(component);
    }

    private void revertWrappedComboBoxItemRenderer(ComboBoxElement component) {
        if (this.getRenderer(component) instanceof HighlightComboBoxItemRenderer) {
            HighlightComboBoxItemRenderer highlightRenderer = (HighlightComboBoxItemRenderer)this.getRenderer(component);
            this.setRenderer(component, highlightRenderer.getOriginalRenderer());
        }
    }

    private ListCellRenderer<Object> getRenderer(ComboBoxElement component) {
        return component.getComboBox().getRenderer();
    }

    private void setRenderer(ComboBoxElement component, ListCellRenderer<Object> renderer) {
        component.getComboBox().setRenderer(renderer);
    }

    public static class HighlightComboBoxItemRenderer
    implements ListCellRenderer<Object> {
        private ArrayList<Integer> highlightedIndexes = new ArrayList();
        private ListCellRenderer<Object> originalRenderer;

        public HighlightComboBoxItemRenderer(ListCellRenderer<Object> originalRenderer) {
            this.originalRenderer = originalRenderer;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component item = this.originalRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (this.highlightedIndexes.contains(index)) {
                this.trySetOpaque(item, true);
                item.setBackground(HighlighterUtils.getHighlightColor());
            } else {
                this.trySetOpaque(item, false);
                item.setBackground(null);
            }
            return item;
        }

        private void trySetOpaque(Component item, boolean isOpaque) {
            if (item instanceof BasicComboBoxRenderer) {
                ((BasicComboBoxRenderer)item).setOpaque(isOpaque);
            }
        }

        public ListCellRenderer<Object> getOriginalRenderer() {
            return this.originalRenderer;
        }

        public void addHighlightedIndex(int itemIndex) {
            this.highlightedIndexes.add(itemIndex);
        }
    }
}

