/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.ModifyVolumeAttributeDescription;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class ModifyVolumeAttribute
extends BaseCmd {
    private static final String[] AUTO_ENABLE_DESC = new String[]{"Set whether or not volume IO should be auto-enabled in the case of a volume event."};
    private String volumeId;
    private ModifyVolumeAttributeDescription attribute;

    public ModifyVolumeAttribute(String[] args) {
        super("ec2mvolatt", "ec2-modify-volume-attribute");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(ModifyVolumeAttribute.createOptionWithArgs("a", "auto-enable-io", AUTO_ENABLE_DESC, "AUTO-ENABLE-IO"));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "VOLUMEID";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("auto-enable-io");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Modifies a volume attribute. Only one attribute can be specified");
        System.out.println("     per call.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        RequestResultPair rsp = jec2.modifyVolumeAttribute(this.volumeId, this.attribute);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputVolumeAttribute(System.out, this.volumeId, this.attribute);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    protected void validateParameters() {
        this.assertNonOptionSet("VOLUMEID");
        this.volumeId = this.getNonOptions()[0];
        this.assertOnlyOneOptionSet(new String[]{"auto-enable-io"});
        this.warnIfTooManyNonOptions();
        if (this.isOptionSet("auto-enable-io")) {
            this.attribute = ModifyVolumeAttributeDescription.createAutoEnableIO((Boolean)this.getBooleanOption("auto-enable-io"));
        }
    }

    public static void main(String[] args) {
        new ModifyVolumeAttribute(args).invoke();
    }
}

