/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.ListOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.util.CollectionUtils;

public final class ListOptionUI<T>
extends OptionUI<ListOption<T>>
implements ListSelectionListener {
    private static final Logger logger = Logger.getLogger(ListOptionUI.class.getName());
    private final JPanel panel;
    private final JList<AbstractOption<T>> list;
    private final DefaultListModel<AbstractOption<T>> model;
    private final JButton editButton = Utility.localizedButton("list.edit");
    private final JButton addButton = Utility.localizedButton("list.add");
    private final JButton removeButton = Utility.localizedButton("list.remove");
    private final JButton upButton = Utility.localizedButton("list.up");
    private final JButton downButton = Utility.localizedButton("list.down");
    private final Function<AbstractOption, Boolean> choiceModifiableCheck;

    public ListOptionUI(GUI gui, ListOption<T> option, boolean editable, Function<AbstractOption, Boolean> choiceModifiableCheck) {
        super(option, editable);
        this.choiceModifiableCheck = choiceModifiableCheck;
        this.panel = new MigPanel(new MigLayout("wrap 2, fill", "[fill, grow]20[fill]"));
        this.panel.setBorder(Utility.localizedBorder(super.getJLabel().getText(), Utility.getBorderColor()));
        this.model = new DefaultListModel();
        Iterator iterator = option.getValue().iterator();
        while (iterator.hasNext()) {
            AbstractOption o = (AbstractOption)iterator.next();
            try {
                Option c = o.cloneOption();
                this.model.addElement((AbstractOption<T>)c);
            }
            catch (CloneNotSupportedException e) {
                logger.log(Level.WARNING, "Can not clone " + o.getId(), e);
            }
        }
        this.list = new JList<AbstractOption<T>>(this.model);
        AbstractOption<T> o = (AbstractOption<T>)CollectionUtils.first(option.getValue());
        if (o == null) {
            o = option.getTemplate();
        }
        if (o != null) {
            this.setCellRenderer(gui, o, editable);
            this.list.setSelectedIndex(0);
        }
        this.list.setVisibleRowCount(4);
        JScrollPane pane = new JScrollPane(this.list);
        this.panel.add((Component)pane, "grow, spany 5");
        if (option.getAllowDuplicates()) {
            this.editButton.setEnabled(editable);
            this.panel.add(this.editButton);
        }
        for (JButton button : new JButton[]{this.addButton, this.removeButton, this.upButton, this.downButton}) {
            button.setEnabled(editable);
            this.panel.add(button);
        }
        if (option.getTemplate() == null) {
            this.addButton.setEnabled(false);
        }
        this.addButton.addActionListener(ae -> {
            try {
                Option ao = option.getTemplate().cloneOption();
                if (gui.showEditOptionDialog(ao) && option.canAdd((AbstractOption<T>)ao)) {
                    if (!option.getAllowDuplicates() && this.getValue().contains(ao)) {
                        return;
                    }
                    if (!this.canModifyChoice((AbstractOption<T>)ao)) {
                        return;
                    }
                    this.model.addElement((AbstractOption<T>)ao);
                    this.list.setSelectedValue(ao, true);
                    this.list.repaint();
                }
            }
            catch (CloneNotSupportedException cnse) {
                logger.log(Level.WARNING, "Can not clone: " + option.getTemplate(), cnse);
            }
        });
        this.editButton.addActionListener(ae -> {
            AbstractOption<T> ao = this.list.getSelectedValue();
            if (gui.showEditOptionDialog(ao)) {
                this.list.repaint();
            }
        });
        this.removeButton.addActionListener(ae -> {
            if (!this.canModifyChoice(this.list.getSelectedValue())) {
                return;
            }
            this.model.removeElementAt(this.list.getSelectedIndex());
        });
        this.upButton.addActionListener(ae -> {
            if (this.list.getSelectedIndex() == 0) {
                return;
            }
            if (!this.canModifyChoice(this.list.getSelectedValue())) {
                return;
            }
            int index = this.list.getSelectedIndex();
            AbstractOption<T> temp = this.model.getElementAt(index);
            this.model.setElementAt(this.model.getElementAt(index - 1), index);
            this.model.setElementAt(temp, index - 1);
            this.list.setSelectedIndex(index - 1);
        });
        this.downButton.addActionListener(ae -> {
            if (this.list.getSelectedIndex() == this.model.getSize() - 1) {
                return;
            }
            if (!this.canModifyChoice(this.list.getSelectedValue())) {
                return;
            }
            int index = this.list.getSelectedIndex();
            AbstractOption<T> temp = this.model.getElementAt(index);
            this.model.setElementAt(this.model.getElementAt(index + 1), index);
            this.model.setElementAt(temp, index + 1);
            this.list.setSelectedIndex(index + 1);
        });
        this.list.addListSelectionListener(this);
        this.initialize();
    }

    private boolean canModifyChoice(AbstractOption<T> choice) {
        return this.choiceModifiableCheck.apply(choice);
    }

    private void setCellRenderer(GUI gui, AbstractOption<T> o, boolean editable) {
        OptionUI ui = OptionUI.getOptionUI(gui, o, editable);
        if (ui != null && ui.getListCellRenderer() != null) {
            this.list.setCellRenderer(ui.getListCellRenderer());
        }
    }

    private List<AbstractOption<T>> getValue() {
        ArrayList<AbstractOption<T>> result = new ArrayList<AbstractOption<T>>();
        Enumeration<AbstractOption<T>> e = this.model.elements();
        while (e.hasMoreElements()) {
            result.add(e.nextElement());
        }
        return result;
    }

    @Override
    public final JLabel getJLabel() {
        return null;
    }

    @Override
    public JPanel getComponent() {
        return this.panel;
    }

    @Override
    public void updateOption() {
        ((ListOption)this.getOption()).setValue(this.getValue());
    }

    @Override
    public void reset() {
        this.model.clear();
        Iterator iterator = ((ListOption)this.getOption()).getValue().iterator();
        while (iterator.hasNext()) {
            AbstractOption o = (AbstractOption)iterator.next();
            this.model.addElement(o);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            boolean enabled = this.isEditable() && this.list.getSelectedValue() != null;
            this.editButton.setEnabled(enabled);
            this.addButton.setEnabled(this.isEditable() && ((ListOption)this.getOption()).getTemplate() != null);
            this.removeButton.setEnabled(enabled);
            this.upButton.setEnabled(enabled);
            this.downButton.setEnabled(enabled);
        }
    }
}

