/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Occupation;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.Utils;

public abstract class WorkLocation
extends UnitLocation
implements Ownable {
    private static final Logger logger = Logger.getLogger(WorkLocation.class.getName());
    public static final List<AbstractGoods> EMPTY_LIST = Collections.emptyList();
    protected Colony colony;
    private ProductionType productionType;
    private static final String COLONY_TAG = "colony";

    protected WorkLocation(Game game) {
        super(game);
    }

    public WorkLocation(Game game, String id) {
        super(game, id);
    }

    public void setColony(Colony colony) {
        this.colony = colony;
    }

    public final ProductionType getProductionType() {
        return this.productionType;
    }

    public final void setProductionType(ProductionType newProductionType) {
        if (!Utils.equals(newProductionType, this.productionType)) {
            this.productionType = newProductionType;
            this.getColony().invalidateCache();
            logger.fine("Production type at " + this + " is now: " + newProductionType);
        }
    }

    public GoodsType getCurrentWorkType() {
        Unit unit = this.getFirstUnit();
        return unit != null && unit.getType() != null ? unit.getWorkType() : null;
    }

    public void updateProductionType() {
        this.setProductionType(this.getBestProductionType(this.isEmpty(), this.getCurrentWorkType()));
    }

    public ProductionType getBestProductionType(boolean unattended, GoodsType workType) {
        return ProductionType.getBestProductionType(workType, this.getAvailableProductionTypes(unattended));
    }

    public Occupation getOccupation(Unit unit, boolean userMode) {
        LogBuilder lb = new LogBuilder(this.getColony().getOccupationTrace() ? 64 : 0);
        lb.add(this.getColony().getName(), "/", this, ".getOccupation(", unit, ")");
        Occupation best = new Occupation(null, null, null);
        int bestAmount = 0;
        for (Collection<GoodsType> types : this.getColony().getWorkTypeChoices(unit, userMode)) {
            lb.add("\n  ");
            WorkLocation.logFreeColObjects(types, lb);
            bestAmount = best.improve(unit, this, bestAmount, types, lb);
            if (best.workType == null) continue;
            lb.add("\n  => ", best);
            break;
        }
        if (best.workType == null) {
            lb.add("\n  FAILED");
        }
        lb.log(logger, Level.WARNING);
        return best.workType == null ? null : best;
    }

    public Occupation getOccupation(UnitType unitType) {
        Specification spec = this.getSpecification();
        if (unitType == null) {
            unitType = spec.getDefaultUnitType(this.getOwner().getNationType());
        }
        LogBuilder lb = new LogBuilder(this.getColony().getOccupationTrace() ? 64 : 0);
        lb.add(this.getColony().getName(), "/", this, ".getOccupation(", unitType.getSuffix(), ")");
        List<GoodsType> types = spec.getGoodsTypeList();
        Occupation best = new Occupation(null, null, null);
        lb.add("\n  ");
        WorkLocation.logFreeColObjects(types, lb);
        int bestAmount = best.improve(unitType, this, 0, types, lb);
        if (best.workType != null) {
            lb.add("\n  => ", best, "/", bestAmount);
        } else {
            lb.add("\n  FAILED");
        }
        lb.log(logger, Level.WARNING);
        return best.workType == null ? null : best;
    }

    public GoodsType getWorkFor(Unit unit) {
        Occupation occupation = this.getOccupation(unit, true);
        return occupation == null ? null : occupation.workType;
    }

    public boolean setWorkFor(Unit unit) {
        Occupation occupation = this.getOccupation(unit, false);
        return occupation != null && occupation.install(unit);
    }

    private Suggestion getSuggestion(Unit unit, ProductionType productionType, GoodsType goodsType) {
        UnitType better;
        if (productionType == null || goodsType == null || (unit == null || !this.contains(unit)) && this.isFull()) {
            return null;
        }
        Specification spec = this.getSpecification();
        Player owner = this.getOwner();
        UnitType expert = spec.getExpertForProducing(goodsType);
        UnitType unitType = better = expert != null ? expert : spec.getDefaultUnitType(owner);
        if (unit != null && better == unit.getType()) {
            return null;
        }
        int delta = this.getPotentialProduction(goodsType, better);
        if (unit != null) {
            delta -= this.getPotentialProduction(goodsType, unit.getType());
        }
        ToIntFunction<AbstractGoods> prod = ag -> this.getColony().getNetProductionOf(ag.getType());
        if ((delta = Math.min(delta, CollectionUtils.min(productionType.getInputs(), prod))) <= 0) {
            return null;
        }
        if (owner.getPlayerType() == Player.PlayerType.INDEPENDENT && (goodsType.isLibertyType() && this.getColony().getSonsOfLiberty() >= 100 || goodsType.isImmigrationType())) {
            return null;
        }
        Boolean ok = this.goodSuggestionCheck(better, unit, goodsType);
        return ok == false ? null : new Suggestion(this, unit == null ? null : unit.getType(), better, goodsType, delta);
    }

    protected boolean goodSuggestionCheck(UnitType unitType, Unit unit, GoodsType goodsType) {
        return this.goodSuggestionCheck(unitType, unit, goodsType, this);
    }

    protected boolean goodSuggestionCheck(UnitType unitType, Unit unit, GoodsType goodsType, WorkLocation workLocation) {
        return false;
    }

    public Map<Unit, Suggestion> getSuggestions() {
        Suggestion sug;
        GoodsType work;
        HashMap<Unit, Suggestion> result = new HashMap<Unit, Suggestion>();
        if (!this.canBeWorked() || this.canTeach()) {
            return result;
        }
        Occupation occ = this.getOccupation(null);
        for (Unit u : CollectionUtils.transform(this.getUnits(), CollectionUtils.isNull(Unit::getTeacher))) {
            work = u.getWorkType();
            if (work == null && occ != null) {
                work = occ.workType;
            }
            if ((sug = this.getSuggestion(u, this.getProductionType(), work)) == null) continue;
            result.put(u, sug);
        }
        if (occ != null && (work = occ.workType) != null && !this.isFull() && (sug = this.getSuggestion(null, occ.productionType, work)) != null) {
            result.put(null, sug);
        }
        return result;
    }

    public Stream<AbstractGoods> getInputs() {
        return this.productionType == null ? Stream.empty() : this.productionType.getInputs();
    }

    public Stream<AbstractGoods> getOutputs() {
        return this.productionType == null ? Stream.empty() : this.productionType.getOutputs();
    }

    public boolean produces(GoodsType goodsType) {
        return CollectionUtils.any(this.getOutputs(), AbstractGoods.matches(goodsType));
    }

    public boolean hasInputs() {
        return CollectionUtils.any(this.getInputs());
    }

    public boolean hasOutputs() {
        return this.productionType != null && CollectionUtils.any(this.productionType.getOutputs());
    }

    public boolean canBeWorked() {
        return this.getNoWorkReason() == UnitLocation.NoAddReason.NONE;
    }

    public boolean canTeach() {
        return this.hasAbility("model.ability.teach");
    }

    public ProductionInfo getProductionInfo() {
        return this.getColony().getProductionInfo(this);
    }

    public List<AbstractGoods> getProduction() {
        ProductionInfo info = this.getProductionInfo();
        return info == null ? EMPTY_LIST : info.getProduction();
    }

    public int getTotalProductionOf(GoodsType goodsType) {
        if (goodsType == null) {
            throw new RuntimeException("Null GoodsType: " + this);
        }
        return AbstractGoods.getCount(goodsType, this.getProduction());
    }

    public int getMaximumProductionOf(GoodsType goodsType) {
        AbstractGoods ag;
        ProductionInfo info = this.getProductionInfo();
        if (info == null) {
            return 0;
        }
        List<AbstractGoods> production = info.getMaximumProduction();
        if (production != null && (ag = CollectionUtils.find(production, AbstractGoods.matches(goodsType))) != null) {
            return ag.getAmount();
        }
        return this.getTotalProductionOf(goodsType);
    }

    public UnitType getExpertUnitType() {
        Specification spec = this.getSpecification();
        ProductionType pt = this.getBestProductionType(false, null);
        return pt == null ? null : CollectionUtils.find(CollectionUtils.map(pt.getOutputs(), ag -> spec.getExpertForProducing(ag.getType())), CollectionUtils.isNotNull());
    }

    public int getGenericPotential(GoodsType goodsType) {
        return this.getPotentialProduction(goodsType, this.getSpecification().getDefaultUnitType(this.getOwner()));
    }

    public int getUnitProduction(Unit unit, GoodsType goodsType) {
        if (unit == null || unit.getWorkType() != goodsType) {
            return 0;
        }
        UnitType unitType = unit.getType();
        Turn turn = this.getGame().getTurn();
        return Math.max(0, (int)WorkLocation.applyModifiers((float)this.getBaseProduction(this.getProductionType(), goodsType, unitType), turn, this.getProductionModifiers(goodsType, unitType)));
    }

    public int getProductionOf(Unit unit, GoodsType goodsType) {
        if (unit == null) {
            throw new RuntimeException("Null unit: " + this);
        }
        return !this.produces(goodsType) ? 0 : Math.max(0, this.getPotentialProduction(goodsType, unit.getType()));
    }

    public int getPotentialProduction(GoodsType goodsType, UnitType unitType) {
        if (!this.canProduce(goodsType, unitType)) {
            return 0;
        }
        if (unitType != null) {
            switch (this.getNoWorkReason()) {
                case NONE: 
                case ALREADY_PRESENT: 
                case CLAIM_REQUIRED: {
                    break;
                }
                case CAPACITY_EXCEEDED: {
                    if (this.getUnitCapacity() > 0) break;
                }
                default: {
                    return 0;
                }
            }
        }
        int amount = this.getBaseProduction(null, goodsType, unitType);
        return (amount = (int)WorkLocation.applyModifiers((float)amount, this.getGame().getTurn(), this.getProductionModifiers(goodsType, unitType))) < 0 ? 0 : amount;
    }

    public AbstractGoods getProductionDeficit(GoodsType goodsType) {
        ProductionInfo pi = this.getProductionInfo();
        return pi == null ? null : CollectionUtils.find(pi.getProductionDeficit(), AbstractGoods.matches(goodsType));
    }

    @Override
    public StringTemplate getLocationLabelFor(Player player) {
        return this.getOwner() == player ? this.getLocationLabel() : this.getColony().getLocationLabelFor(player);
    }

    @Override
    public final Tile getTile() {
        return this.getSettlement().getTile();
    }

    @Override
    public boolean add(Locatable locatable) {
        UnitLocation.NoAddReason reason = this.getNoAddReason(locatable);
        switch (reason) {
            case NONE: {
                break;
            }
            case ALREADY_PRESENT: {
                return true;
            }
            default: {
                throw new IllegalStateException("Can not add " + locatable + " to " + this + " because " + reason);
            }
        }
        Unit unit = (Unit)locatable;
        if (!super.add(unit)) {
            return false;
        }
        unit.setState(Unit.UnitState.IN_COLONY);
        unit.setMovesLeft(0);
        this.setWorkFor(unit);
        this.getColony().invalidateCache();
        return true;
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            throw new IllegalStateException("Not a unit: " + locatable);
        }
        Unit unit = (Unit)locatable;
        if (!this.contains(unit)) {
            return true;
        }
        if (!super.remove(unit)) {
            return false;
        }
        unit.setState(Unit.UnitState.ACTIVE);
        unit.setMovesLeft(0);
        if (this.isEmpty()) {
            this.updateProductionType();
        }
        this.getColony().invalidateCache();
        return true;
    }

    @Override
    public final Settlement getSettlement() {
        return this.colony;
    }

    @Override
    public final Colony getColony() {
        return this.colony;
    }

    @Override
    public final int getRank() {
        return Location.rankOf(this.getTile());
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        if (locatable instanceof Unit && ((Unit)locatable).isDamaged()) {
            return UnitLocation.NoAddReason.WORKER_DAMAGED;
        }
        return locatable instanceof Unit && ((Unit)locatable).isPerson() ? super.getNoAddReason(locatable) : UnitLocation.NoAddReason.WRONG_TYPE;
    }

    public abstract StringTemplate getLabel();

    public abstract boolean isAvailable();

    public abstract boolean isCurrent();

    public abstract UnitLocation.NoAddReason getNoWorkReason();

    public abstract Tile getWorkTile();

    public abstract int getLevel();

    public abstract boolean canAutoProduce();

    public abstract boolean canProduce(GoodsType var1, UnitType var2);

    public abstract int getBaseProduction(ProductionType var1, GoodsType var2, UnitType var3);

    public abstract Stream<Modifier> getProductionModifiers(GoodsType var1, UnitType var2);

    public abstract List<ProductionType> getAvailableProductionTypes(boolean var1);

    public abstract float getCompetenceFactor();

    public abstract float getRebelFactor();

    public int evaluateFor(Player player) {
        int result = 0;
        for (Unit u : this.getUnitList()) {
            int v = u.evaluateFor(player);
            if (v == Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            result += v;
        }
        return result;
    }

    public StringTemplate getClaimTemplate() {
        return StringTemplate.name("");
    }

    @Override
    public Player getOwner() {
        Colony colony = this.getColony();
        return colony == null ? null : colony.getOwner();
    }

    @Override
    public void setOwner(Player p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        WorkLocation o = this.copyInCast(other, WorkLocation.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.colony = this.getGame().updateRef(o.getColony());
        this.productionType = o.getProductionType();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(COLONY_TAG, this.colony);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.productionType != null) {
            this.productionType.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.colony = xr.findFreeColGameObject(this.getGame(), COLONY_TAG, Colony.class, null, true);
    }

    @Override
    public void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if ("production".equals(tag)) {
            this.productionType = new ProductionType(xr, spec);
        } else {
            super.readChild(xr);
        }
    }

    public static class Suggestion {
        public static final Comparator<Suggestion> descendingAmountComparator = Comparator.comparingInt(Suggestion::getAmount).reversed().thenComparing(Suggestion::getGoodsType, GoodsType.goodsTypeComparator).thenComparing(Suggestion::getNewUnitType);
        public final WorkLocation workLocation;
        public final UnitType oldType;
        public final UnitType newType;
        public final GoodsType goodsType;
        public final int amount;

        public Suggestion(WorkLocation workLocation, UnitType oldType, UnitType newType, GoodsType goodsType, int amount) {
            this.workLocation = workLocation;
            this.oldType = oldType;
            this.newType = newType;
            this.goodsType = goodsType;
            this.amount = amount;
        }

        public UnitType getNewUnitType() {
            return this.newType;
        }

        public GoodsType getGoodsType() {
            return this.goodsType;
        }

        public int getAmount() {
            return this.amount;
        }
    }
}

