/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;

public class FountainOfYouthMessage
extends AttributeMessage {
    public static final String TAG = "fountainOfYouth";
    private static final String MIGRANTS_TAG = "migrants";

    public FountainOfYouthMessage(int migrants) {
        super(TAG, MIGRANTS_TAG, String.valueOf(migrants));
    }

    public FountainOfYouthMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, MIGRANTS_TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.LATE;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
        int n = this.getMigrants();
        aiPlayer.fountainOfYouthHandler(n);
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        int n = this.getMigrants();
        if (n <= 0) {
            logger.warning("Invalid migrants attribute: " + n);
            return;
        }
        this.igc(freeColClient).fountainOfYouthHandler(n);
        this.clientGeneric(freeColClient);
    }

    public int getMigrants() {
        return this.getIntegerAttribute(MIGRANTS_TAG, -1);
    }
}

