/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.initialization;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.provider.ConfigurationTimeBarrier;
import org.gradle.internal.cc.impl.DeprecatedFeaturesListenerKt;
import org.gradle.internal.cc.impl.InputTrackingState;
import org.gradle.internal.cc.impl.Workarounds;
import org.gradle.internal.cc.impl.initialization.ConfigurationCacheProblemsListener;
import org.gradle.internal.configuration.problems.DocumentationSection;
import org.gradle.internal.configuration.problems.ProblemFactory;
import org.gradle.internal.configuration.problems.ProblemsListener;
import org.gradle.internal.configuration.problems.PropertyProblem;
import org.gradle.internal.configuration.problems.PropertyTrace;
import org.gradle.internal.configuration.problems.StructuredMessage;
import org.gradle.internal.execution.WorkExecutionTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u000eH\u0002J\b\u0010\u001a\u001a\u00020\u000eH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010 \u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\"\u0010(\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#2\b\u0010)\u001a\u0004\u0018\u00010#H\u0016J\u001a\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0016J\"\u0010,\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#2\b\u0010)\u001a\u0004\u0018\u00010#H\u0016J\"\u0010-\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#2\b\u0010)\u001a\u0004\u0018\u00010#H\u0016J\"\u0010.\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#2\b\u0010)\u001a\u0004\u0018\u00010#H\u0002J\u0010\u0010/\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/gradle/internal/cc/impl/initialization/DefaultConfigurationCacheProblemsListener;", "Lorg/gradle/internal/cc/impl/initialization/ConfigurationCacheProblemsListener;", "problems", "Lorg/gradle/internal/configuration/problems/ProblemsListener;", "problemFactory", "Lorg/gradle/internal/configuration/problems/ProblemFactory;", "configurationTimeBarrier", "Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;", "workExecutionTracker", "Lorg/gradle/internal/execution/WorkExecutionTracker;", "inputTrackingState", "Lorg/gradle/internal/cc/impl/InputTrackingState;", "(Lorg/gradle/internal/configuration/problems/ProblemsListener;Lorg/gradle/internal/configuration/problems/ProblemFactory;Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;Lorg/gradle/internal/execution/WorkExecutionTracker;Lorg/gradle/internal/cc/impl/InputTrackingState;)V", "atConfigurationTime", "", "disallowedAtExecutionInjectedServiceAccessed", "", "injectedServiceType", "Ljava/lang/Class;", "getterName", "", "consumer", "isBuildSrcBuild", "invocationSource", "", "isExecutingWork", "isInputTrackingDisabled", "listenerRegistrationProblem", "Lorg/gradle/internal/configuration/problems/PropertyProblem;", "invocationDescription", "exception", "Lorg/gradle/api/InvalidUserCodeException;", "locationForTask", "Lorg/gradle/internal/configuration/problems/PropertyTrace$Task;", "task", "Lorg/gradle/api/internal/TaskInternal;", "Lorg/gradle/internal/configuration/problems/PropertyTrace;", "location", "onBuildScopeListenerRegistration", "listener", "onConventionAccess", "runningTask", "onExternalProcessStarted", "command", "onProjectAccess", "onTaskDependenciesAccess", "onTaskExecutionAccessProblem", "problemsListenerFor", "configuration-cache"})
public final class DefaultConfigurationCacheProblemsListener
implements ConfigurationCacheProblemsListener {
    @NotNull
    private final ProblemsListener problems;
    @NotNull
    private final ProblemFactory problemFactory;
    @NotNull
    private final ConfigurationTimeBarrier configurationTimeBarrier;
    @NotNull
    private final WorkExecutionTracker workExecutionTracker;
    @NotNull
    private final InputTrackingState inputTrackingState;

    public DefaultConfigurationCacheProblemsListener(@NotNull ProblemsListener problems, @NotNull ProblemFactory problemFactory, @NotNull ConfigurationTimeBarrier configurationTimeBarrier, @NotNull WorkExecutionTracker workExecutionTracker, @NotNull InputTrackingState inputTrackingState) {
        Intrinsics.checkNotNullParameter((Object)problems, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)problemFactory, (String)"problemFactory");
        Intrinsics.checkNotNullParameter((Object)configurationTimeBarrier, (String)"configurationTimeBarrier");
        Intrinsics.checkNotNullParameter((Object)workExecutionTracker, (String)"workExecutionTracker");
        Intrinsics.checkNotNullParameter((Object)inputTrackingState, (String)"inputTrackingState");
        this.problems = problems;
        this.problemFactory = problemFactory;
        this.configurationTimeBarrier = configurationTimeBarrier;
        this.workExecutionTracker = workExecutionTracker;
        this.inputTrackingState = inputTrackingState;
    }

    public void disallowedAtExecutionInjectedServiceAccessed(@NotNull Class<?> injectedServiceType, @NotNull String getterName, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter(injectedServiceType, (String)"injectedServiceType");
        Intrinsics.checkNotNullParameter((Object)getterName, (String)"getterName");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        PropertyProblem problem2 = this.problemFactory.problem(consumer, (Function1)new Function1<StructuredMessage.Builder, Unit>(injectedServiceType, getterName){
            final /* synthetic */ Class<?> $injectedServiceType;
            final /* synthetic */ String $getterName;
            {
                this.$injectedServiceType = $injectedServiceType;
                this.$getterName = $getterName;
                super(1);
            }

            public final void invoke(StructuredMessage.Builder $this$problem) {
                Intrinsics.checkNotNullParameter((Object)$this$problem, (String)"$this$problem");
                $this$problem.text("accessing non-serializable type ");
                $this$problem.reference(this.$injectedServiceType);
                $this$problem.text(" caused by invocation ");
                $this$problem.reference(this.$getterName);
            }
        }).exception("Accessing non-serializable type '" + injectedServiceType + "' during execution time is unsupported.").documentationSection(DocumentationSection.RequirementsDisallowedTypes).build();
        this.problems.onProblem(problem2);
    }

    public void onProjectAccess(@NotNull String invocationDescription, @NotNull TaskInternal task, @Nullable TaskInternal runningTask) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.onTaskExecutionAccessProblem(invocationDescription, task, runningTask);
    }

    public void onConventionAccess(@NotNull String invocationDescription, @NotNull TaskInternal task, @Nullable TaskInternal runningTask) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String string2 = task.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"task.javaClass.name");
        if (Workarounds.INSTANCE.canAccessConventions(string2, invocationDescription)) {
            return;
        }
        this.onTaskExecutionAccessProblem(invocationDescription, task, runningTask);
    }

    public void onTaskDependenciesAccess(@NotNull String invocationDescription, @NotNull TaskInternal task, @Nullable TaskInternal runningTask) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.onTaskExecutionAccessProblem(invocationDescription, task, runningTask);
    }

    public void onExternalProcessStarted(@NotNull String command, @Nullable String consumer) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (!this.atConfigurationTime() || this.isExecutingWork() || this.isInputTrackingDisabled()) {
            return;
        }
        PropertyProblem problem2 = this.problemFactory.problem(consumer, (Function1)new Function1<StructuredMessage.Builder, Unit>(command){
            final /* synthetic */ String $command;
            {
                this.$command = $command;
                super(1);
            }

            public final void invoke(StructuredMessage.Builder $this$problem) {
                Intrinsics.checkNotNullParameter((Object)$this$problem, (String)"$this$problem");
                $this$problem.text("external process started ");
                $this$problem.reference(this.$command);
            }
        }).exception("Starting an external process '" + command + "' during configuration time is unsupported.").documentationSection(DocumentationSection.RequirementsExternalProcess).build();
        this.problems.onProblem(problem2);
    }

    private final void onTaskExecutionAccessProblem(String invocationDescription, TaskInternal task, TaskInternal runningTask) {
        TaskInternal contextTask;
        TaskInternal taskInternal = runningTask;
        if (taskInternal == null) {
            taskInternal = task;
        }
        boolean isExecutingOtherTask = !Intrinsics.areEqual((Object)(contextTask = taskInternal), (Object)task);
        this.problemsListenerFor(contextTask).onProblem(ProblemFactory.DefaultImpls.problem$default((ProblemFactory)this.problemFactory, null, (Function1)((Function1)new Function1<StructuredMessage.Builder, Unit>(isExecutingOtherTask, contextTask, invocationDescription){
            final /* synthetic */ boolean $isExecutingOtherTask;
            final /* synthetic */ TaskInternal $contextTask;
            final /* synthetic */ String $invocationDescription;
            {
                this.$isExecutingOtherTask = $isExecutingOtherTask;
                this.$contextTask = $contextTask;
                this.$invocationDescription = $invocationDescription;
                super(1);
            }

            public final void invoke(StructuredMessage.Builder $this$problem) {
                Intrinsics.checkNotNullParameter((Object)$this$problem, (String)"$this$problem");
                if (this.$isExecutingOtherTask) {
                    $this$problem.text("execution of task ");
                    String string2 = this.$contextTask.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"contextTask.path");
                    $this$problem.reference(string2);
                    $this$problem.text(" caused invocation of ");
                    $this$problem.reference(this.$invocationDescription);
                    $this$problem.text(" in other task at execution time which is unsupported.");
                } else {
                    $this$problem.text("invocation of ");
                    $this$problem.reference(this.$invocationDescription);
                    $this$problem.text(" at execution time is unsupported.");
                }
            }
        }), (int)1, null).exception(isExecutingOtherTask ? "Execution of " + runningTask + " caused invocation of '" + invocationDescription + "' by " + task + " at execution time which is unsupported." : "Invocation of '" + invocationDescription + "' by " + task + " at execution time is unsupported.").documentationSection(DocumentationSection.RequirementsUseProjectDuringExecution).mapLocation((Function1)new Function1<PropertyTrace, PropertyTrace>(this, contextTask){
            final /* synthetic */ DefaultConfigurationCacheProblemsListener this$0;
            final /* synthetic */ TaskInternal $contextTask;
            {
                this.this$0 = $receiver;
                this.$contextTask = $contextTask;
                super(1);
            }

            public final PropertyTrace invoke(PropertyTrace it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return DefaultConfigurationCacheProblemsListener.access$locationForTask(this.this$0, it2, this.$contextTask);
            }
        }).build());
    }

    private final PropertyTrace locationForTask(PropertyTrace location, TaskInternal task) {
        PropertyTrace propertyTrace = location;
        return propertyTrace instanceof PropertyTrace.BuildLogic ? location : (propertyTrace instanceof PropertyTrace.Task ? location : (PropertyTrace)this.locationForTask(task));
    }

    private final PropertyTrace.Task locationForTask(TaskInternal task) {
        Class clazz = GeneratedSubclasses.unpackType((Object)task);
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"unpackType(task)");
        String string2 = task.getIdentityPath().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"task.identityPath.path");
        return new PropertyTrace.Task(clazz, string2);
    }

    private final ProblemsListener problemsListenerFor(TaskInternal task) {
        ProblemsListener problemsListener;
        if (task.isCompatibleWithConfigurationCache()) {
            problemsListener = this.problems;
        } else {
            PropertyTrace propertyTrace = (PropertyTrace)this.locationForTask(task);
            Object t = task.getReasonTaskIsIncompatibleWithConfigurationCache().get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"task.reasonTaskIsIncompa\u2026hConfigurationCache.get()");
            problemsListener = this.problems.forIncompatibleTask(propertyTrace, (String)t);
        }
        return problemsListener;
    }

    public void onBuildScopeListenerRegistration(@NotNull Object listener2, @NotNull String invocationDescription, @NotNull Object invocationSource) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)invocationSource, (String)"invocationSource");
        if (this.isBuildSrcBuild(invocationSource) || DeprecatedFeaturesListenerKt.isSupportedListener(listener2)) {
            return;
        }
        this.problems.onProblem(this.listenerRegistrationProblem(invocationDescription, new InvalidUserCodeException("Listener registration '" + invocationDescription + "' by " + invocationSource + " is unsupported.")));
    }

    private final PropertyProblem listenerRegistrationProblem(String invocationDescription, InvalidUserCodeException exception) {
        return ProblemFactory.DefaultImpls.problem$default((ProblemFactory)this.problemFactory, (StructuredMessage)StructuredMessage.Companion.build((Function1)new Function1<StructuredMessage.Builder, Unit>(invocationDescription){
            final /* synthetic */ String $invocationDescription;
            {
                this.$invocationDescription = $invocationDescription;
                super(1);
            }

            public final void invoke(StructuredMessage.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                $this$build.text("registration of listener on ");
                $this$build.reference(this.$invocationDescription);
                $this$build.text(" is unsupported");
            }
        }), (Throwable)((Throwable)exception), (DocumentationSection)DocumentationSection.RequirementsBuildListeners, (boolean)false, (int)8, null);
    }

    private final boolean isBuildSrcBuild(Object invocationSource) {
        boolean bl;
        GradleInternal gradleInternal = invocationSource instanceof GradleInternal ? (GradleInternal)invocationSource : null;
        if (gradleInternal != null) {
            GradleInternal $this$isBuildSrcBuild_u24lambda_u240 = gradleInternal;
            boolean bl2 = false;
            bl = !$this$isBuildSrcBuild_u24lambda_u240.isRootBuild() && Intrinsics.areEqual((Object)$this$isBuildSrcBuild_u24lambda_u240.getIdentityPath().getName(), (Object)"buildSrc");
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean atConfigurationTime() {
        return this.configurationTimeBarrier.isAtConfigurationTime();
    }

    private final boolean isInputTrackingDisabled() {
        return !this.inputTrackingState.isEnabledForCurrentThread();
    }

    private final boolean isExecutingWork() {
        return this.workExecutionTracker.getCurrentTask().isPresent() || this.workExecutionTracker.isExecutingTransformAction();
    }

    public static final /* synthetic */ PropertyTrace access$locationForTask(DefaultConfigurationCacheProblemsListener $this, PropertyTrace location, TaskInternal task) {
        return $this.locationForTask(location, task);
    }
}

