/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow.conditions;

import java.util.List;
import java.util.Map;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.ResourceType;
import org.keycloak.models.workflow.WorkflowConditionProvider;
import org.keycloak.models.workflow.WorkflowEvent;

public class UserAttributeWorkflowConditionProvider
implements WorkflowConditionProvider {
    private final Map<String, List<String>> expectedAttributes;
    private final KeycloakSession session;

    public UserAttributeWorkflowConditionProvider(KeycloakSession session, Map<String, List<String>> expectedAttributes) {
        this.session = session;
        this.expectedAttributes = expectedAttributes;
    }

    public boolean evaluate(WorkflowEvent event) {
        if (!ResourceType.USERS.equals((Object)event.getResourceType())) {
            return false;
        }
        String userId = event.getResourceId();
        RealmModel realm = this.session.getContext().getRealm();
        UserModel user = this.session.users().getUserById(realm, userId);
        if (user == null) {
            return false;
        }
        for (Map.Entry<String, List<String>> expected : this.expectedAttributes.entrySet()) {
            List values = user.getAttributes().getOrDefault(expected.getKey(), List.of());
            List<String> expectedValues = expected.getValue();
            if (CollectionUtil.collectionEquals(expectedValues, values)) continue;
            return false;
        }
        return true;
    }

    public void validate() {
    }

    public void close() {
    }
}

