/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.StringTokenizer;
import org.jfree.layouting.input.style.CSSDeclarationRule;
import org.jfree.layouting.input.style.CSSStyleRule;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.parser.CSSParserContext;
import org.jfree.layouting.input.style.parser.CSSParserFactory;
import org.jfree.layouting.input.style.parser.CSSParserInstantiationException;
import org.jfree.layouting.input.style.parser.StyleSheetHandler;
import org.jfree.layouting.input.style.values.CSSValue;
import org.pentaho.reporting.libraries.base.util.LFUMap;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SelectorList;

public final class StyleSheetParserUtil {
    private static StyleSheetParserUtil singleton;
    private Parser parser;
    private StyleKeyRegistry registry = StyleKeyRegistry.getRegistry();
    private LFUMap lexicalValueCache = new LFUMap(100);

    public static synchronized StyleSheetParserUtil getInstance() {
        if (singleton == null) {
            singleton = new StyleSheetParserUtil();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectorList parseSelector(Map map, String string, ResourceManager resourceManager, ResourceKey resourceKey) {
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            Parser parser;
            Parser parser2 = parser = this.getParser();
            synchronized (parser2) {
                StyleSheetHandler styleSheetHandler = new StyleSheetHandler();
                styleSheetHandler.init(resourceManager, resourceKey, -1L, StyleKeyRegistry.getRegistry(), null);
                this.setupNamespaces(map, styleSheetHandler);
                InputSource inputSource = new InputSource();
                inputSource.setCharacterStream((Reader)new StringReader(string));
                styleSheetHandler.initParseContext(inputSource);
                styleSheetHandler.setStyleRule(new CSSStyleRule(null, null));
                parser.setDocumentHandler((DocumentHandler)styleSheetHandler);
                SelectorList selectorList = parser.parseSelectors(inputSource);
                CSSParserContext.getContext().destroy();
                return selectorList;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void setupNamespaces(Map map, StyleSheetHandler styleSheetHandler) {
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            styleSheetHandler.registerNamespace(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSValue parseStyleValue(Map map, StyleKey styleKey, String string, ResourceManager resourceManager, ResourceKey resourceKey) {
        if (styleKey == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            Parser parser;
            Parser parser2 = parser = this.getParser();
            synchronized (parser2) {
                StyleSheetHandler styleSheetHandler = new StyleSheetHandler();
                this.setupNamespaces(map, styleSheetHandler);
                styleSheetHandler.init(resourceManager, resourceKey, -1L, this.registry, null);
                InputSource inputSource = new InputSource();
                inputSource.setCharacterStream((Reader)new StringReader(string));
                styleSheetHandler.initParseContext(inputSource);
                styleSheetHandler.setStyleRule(new CSSStyleRule(null, null));
                parser.setDocumentHandler((DocumentHandler)styleSheetHandler);
                LexicalUnit lexicalUnit = parser.parsePropertyValue(inputSource);
                styleSheetHandler.property(styleKey.getName(), lexicalUnit, false);
                CSSStyleRule cSSStyleRule = (CSSStyleRule)styleSheetHandler.getStyleRule();
                CSSParserContext.getContext().destroy();
                return cSSStyleRule.getPropertyCSSValue(styleKey);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LexicalUnit parseLexicalStyleValue(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            Parser parser;
            Parser parser2 = parser = this.getParser();
            synchronized (parser2) {
                Object object = this.lexicalValueCache.get((Object)string);
                if (object != null) {
                    return (LexicalUnit)object;
                }
                StyleSheetHandler styleSheetHandler = new StyleSheetHandler();
                styleSheetHandler.init(null, null, -1L, this.registry, null);
                InputSource inputSource = new InputSource();
                inputSource.setCharacterStream((Reader)new StringReader(string));
                styleSheetHandler.initParseContext(inputSource);
                parser.setDocumentHandler((DocumentHandler)styleSheetHandler);
                LexicalUnit lexicalUnit = parser.parsePropertyValue(inputSource);
                this.lexicalValueCache.put((Object)string, (Object)lexicalUnit);
                return lexicalUnit;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public CSSStyleRule parseStyles(Map map, StyleKey styleKey, String string, ResourceManager resourceManager, ResourceKey resourceKey) {
        if (styleKey == null) {
            throw new NullPointerException();
        }
        return this.parseStyles(map, styleKey.getName(), string, resourceManager, resourceKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSDeclarationRule parseStyleRule(Map map, String string, ResourceManager resourceManager, ResourceKey resourceKey, CSSDeclarationRule cSSDeclarationRule) {
        if (string == null) {
            throw new NullPointerException("Name is null");
        }
        try {
            Parser parser;
            Parser parser2 = parser = this.getParser();
            synchronized (parser2) {
                StyleSheetHandler styleSheetHandler = new StyleSheetHandler();
                this.setupNamespaces(map, styleSheetHandler);
                styleSheetHandler.init(resourceManager, resourceKey, -1L, this.registry, null);
                InputSource inputSource = new InputSource();
                inputSource.setCharacterStream((Reader)new StringReader(string));
                styleSheetHandler.initParseContext(inputSource);
                styleSheetHandler.setStyleRule(cSSDeclarationRule);
                parser.setDocumentHandler((DocumentHandler)styleSheetHandler);
                parser.parseStyleDeclaration(inputSource);
                CSSDeclarationRule cSSDeclarationRule2 = styleSheetHandler.getStyleRule();
                CSSParserContext.getContext().destroy();
                return cSSDeclarationRule2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public CSSStyleRule parseStyles(Map map, String string, String string2, ResourceManager resourceManager, ResourceKey resourceKey) {
        return this.parseStyles(map, string, string2, resourceManager, resourceKey, new CSSStyleRule(null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSStyleRule parseStyles(Map map, String string, String string2, ResourceManager resourceManager, ResourceKey resourceKey, CSSDeclarationRule cSSDeclarationRule) {
        if (string == null) {
            throw new NullPointerException("Name is null");
        }
        if (string2 == null) {
            throw new NullPointerException("Value is null");
        }
        try {
            Parser parser;
            Parser parser2 = parser = this.getParser();
            synchronized (parser2) {
                StyleSheetHandler styleSheetHandler = new StyleSheetHandler();
                styleSheetHandler.init(resourceManager, resourceKey, -1L, StyleKeyRegistry.getRegistry(), null);
                this.setupNamespaces(map, styleSheetHandler);
                InputSource inputSource = new InputSource();
                inputSource.setCharacterStream((Reader)new StringReader(string2));
                styleSheetHandler.initParseContext(inputSource);
                styleSheetHandler.setStyleRule(cSSDeclarationRule);
                parser.setDocumentHandler((DocumentHandler)styleSheetHandler);
                LexicalUnit lexicalUnit = parser.parsePropertyValue(inputSource);
                styleSheetHandler.property(string, lexicalUnit, false);
                CSSStyleRule cSSStyleRule = (CSSStyleRule)styleSheetHandler.getStyleRule();
                CSSParserContext.getContext().destroy();
                return cSSStyleRule;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private synchronized Parser getParser() throws CSSParserInstantiationException {
        if (this.parser == null) {
            this.parser = CSSParserFactory.getInstance().createCSSParser();
        }
        return this.parser;
    }

    public static String[] parseNamespaceIdent(String string) {
        String string2;
        String string3;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        CSSParserContext cSSParserContext = CSSParserContext.getContext();
        if (stringTokenizer.countTokens() == 2) {
            String string4 = stringTokenizer.nextToken();
            string3 = string4.length() == 0 ? null : ("*".equals(string4) ? "*" : (String)cSSParserContext.getNamespaces().get(string4));
            string2 = stringTokenizer.nextToken();
        } else {
            string2 = stringTokenizer.nextToken();
            string3 = cSSParserContext.getDefaultNamespace();
        }
        return new String[]{string3, string2};
    }
}

