/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.navigation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.navigation.ClassMemberPanelUI;
import org.netbeans.modules.csl.navigation.ElementNode;
import org.netbeans.modules.csl.navigation.base.FiltersDescription;
import org.netbeans.modules.csl.navigation.base.FiltersManager;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class ClassMemberFilters {
    private ClassMemberPanelUI ui;
    private static final String SHOW_NON_PUBLIC = "show_non_public";
    private static final String SHOW_STATIC = "show_static";
    private static final String SHOW_FIELDS = "show_fields";
    private static final String SHOW_INHERITED = "show_inherited";
    private FiltersManager filters;
    private boolean naturalSort = false;
    public boolean disableFiltering = false;

    ClassMemberFilters(ClassMemberPanelUI ui) {
        this.ui = ui;
    }

    public FiltersManager getInstance() {
        if (this.filters == null) {
            this.filters = ClassMemberFilters.createFilters();
        }
        return this.filters;
    }

    public JComponent getComponent() {
        FiltersManager f = this.getInstance();
        return f.getComponent();
    }

    public Collection<StructureItem> filter(List<StructureItem> original) {
        boolean non_public = this.filters.isSelected(SHOW_NON_PUBLIC);
        boolean statik = this.filters.isSelected(SHOW_STATIC);
        boolean fields = this.filters.isSelected(SHOW_FIELDS);
        boolean inherited = this.filters.isSelected(SHOW_INHERITED);
        if (original == null || original.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<StructureItem> result = new ArrayList<StructureItem>(original.size());
        if (!this.disableFiltering) {
            for (StructureItem description : original) {
                if (!non_public && (description.getModifiers().contains(Modifier.PROTECTED) || description.getModifiers().contains(Modifier.PRIVATE)) || !statik && description.getModifiers().contains(Modifier.STATIC) || !fields && (description.getKind() == ElementKind.FIELD || description.getKind() == ElementKind.ATTRIBUTE) || !inherited && StructureItem.isInherited(description)) continue;
                result.add(description);
            }
        } else {
            result.addAll(original);
        }
        result.sort(this.isNaturalSort() ? ElementNode.Description.POSITION_COMPARATOR : ElementNode.Description.ALPHA_COMPARATOR);
        return result;
    }

    public boolean isNaturalSort() {
        return this.naturalSort;
    }

    public void setNaturalSort(boolean naturalSort) {
        this.naturalSort = naturalSort;
        this.ui.sort();
    }

    private static FiltersManager createFilters() {
        FiltersDescription desc = new FiltersDescription();
        desc.addFilter(SHOW_INHERITED, NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowInherited"), NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowInheritedTip"), false, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/csl/navigation/resources/filterHideInherited.png", (boolean)false), null);
        desc.addFilter(SHOW_FIELDS, NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowFields"), NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowFieldsTip"), true, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/csl/navigation/resources/filterHideFields.gif", (boolean)false), null);
        desc.addFilter(SHOW_STATIC, NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowStatic"), NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowStaticTip"), true, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/csl/navigation/resources/filterHideStatic.png", (boolean)false), null);
        desc.addFilter(SHOW_NON_PUBLIC, NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowNonPublic"), NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowNonPublicTip"), true, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/csl/navigation/resources/filterHideNonPublic.png", (boolean)false), null);
        return FiltersDescription.createManager(desc);
    }
}

