/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import io.fabric8.kubernetes.api.model.QuantityFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class EmptyDirVolumeSourceFluentImpl<A extends EmptyDirVolumeSourceFluent<A>>
extends BaseFluent<A>
implements EmptyDirVolumeSourceFluent<A> {
    private String medium;
    private QuantityBuilder sizeLimit;
    private Map<String, Object> additionalProperties;

    public EmptyDirVolumeSourceFluentImpl() {
    }

    public EmptyDirVolumeSourceFluentImpl(EmptyDirVolumeSource instance) {
        if (instance != null) {
            this.withMedium(instance.getMedium());
            this.withSizeLimit(instance.getSizeLimit());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getMedium() {
        return this.medium;
    }

    @Override
    public A withMedium(String medium) {
        this.medium = medium;
        return (A)this;
    }

    @Override
    public Boolean hasMedium() {
        return this.medium != null;
    }

    @Override
    @Deprecated
    public Quantity getSizeLimit() {
        return this.sizeLimit != null ? this.sizeLimit.build() : null;
    }

    @Override
    public Quantity buildSizeLimit() {
        return this.sizeLimit != null ? this.sizeLimit.build() : null;
    }

    @Override
    public A withSizeLimit(Quantity sizeLimit) {
        this._visitables.get("sizeLimit").remove(this.sizeLimit);
        if (sizeLimit != null) {
            this.sizeLimit = new QuantityBuilder(sizeLimit);
            this._visitables.get("sizeLimit").add(this.sizeLimit);
        } else {
            this.sizeLimit = null;
            this._visitables.get("sizeLimit").remove(this.sizeLimit);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSizeLimit() {
        return this.sizeLimit != null;
    }

    @Override
    public A withNewSizeLimit(String amount, String format) {
        return this.withSizeLimit(new Quantity(amount, format));
    }

    @Override
    public A withNewSizeLimit(String amount) {
        return this.withSizeLimit(new Quantity(amount));
    }

    @Override
    public EmptyDirVolumeSourceFluent.SizeLimitNested<A> withNewSizeLimit() {
        return new SizeLimitNestedImpl();
    }

    @Override
    public EmptyDirVolumeSourceFluent.SizeLimitNested<A> withNewSizeLimitLike(Quantity item) {
        return new SizeLimitNestedImpl(item);
    }

    @Override
    public EmptyDirVolumeSourceFluent.SizeLimitNested<A> editSizeLimit() {
        return this.withNewSizeLimitLike(this.getSizeLimit());
    }

    @Override
    public EmptyDirVolumeSourceFluent.SizeLimitNested<A> editOrNewSizeLimit() {
        return this.withNewSizeLimitLike(this.getSizeLimit() != null ? this.getSizeLimit() : new QuantityBuilder().build());
    }

    @Override
    public EmptyDirVolumeSourceFluent.SizeLimitNested<A> editOrNewSizeLimitLike(Quantity item) {
        return this.withNewSizeLimitLike(this.getSizeLimit() != null ? this.getSizeLimit() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EmptyDirVolumeSourceFluentImpl that = (EmptyDirVolumeSourceFluentImpl)o;
        if (!Objects.equals(this.medium, that.medium)) {
            return false;
        }
        if (!Objects.equals(this.sizeLimit, that.sizeLimit)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.medium, this.sizeLimit, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.medium != null) {
            sb.append("medium:");
            sb.append(this.medium + ",");
        }
        if (this.sizeLimit != null) {
            sb.append("sizeLimit:");
            sb.append(this.sizeLimit + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SizeLimitNestedImpl<N>
    extends QuantityFluentImpl<EmptyDirVolumeSourceFluent.SizeLimitNested<N>>
    implements EmptyDirVolumeSourceFluent.SizeLimitNested<N>,
    Nested<N> {
        QuantityBuilder builder;

        SizeLimitNestedImpl(Quantity item) {
            this.builder = new QuantityBuilder(this, item);
        }

        SizeLimitNestedImpl() {
            this.builder = new QuantityBuilder(this);
        }

        @Override
        public N and() {
            return (N)EmptyDirVolumeSourceFluentImpl.this.withSizeLimit(this.builder.build());
        }

        @Override
        public N endSizeLimit() {
            return this.and();
        }
    }
}

